#include "comserver.h"
#pragma comment(linker, "/EXPORT:DllRegisterServer=_DllRegisterServer@0,PRIVATE")
#pragma comment(linker, "/EXPORT:DllUnregisterServer=_DllUnregisterServer@0,PRIVATE")
#pragma comment(linker, "/EXPORT:DllCanUnloadNow=_DllCanUnloadNow@0,PRIVATE")
#pragma comment(linker, "/EXPORT:DllGetClassObject=_DllGetClassObject@12,PRIVATE")

// Data keeping loaded ComData objects.
COMDATA** ComDatas;
int NumComDatas=0;
void RegisterComData(COMDATA* data){
	int i;
	COMDATA** temp=new COMDATA*[NumComDatas+1];
	for (i=0;i<NumComDatas;i++) temp[i]=ComDatas[i];
	delete ComDatas;
	ComDatas=temp;
	ComDatas[NumComDatas++]=data;
}
void DeleteComData(COMDATA* data){
	int i;
	for (i=0;i<NumComDatas;i++) {
		if (data==ComDatas[i]) delete ComDatas[i];
		data=0;
	}
}

//Standard COM server

// CServer class holds global object count
class CServer
{
public:
  CServer() : m_hInstance(NULL), m_dwRef(0)
  {}
  HINSTANCE m_hInstance;
  DWORD m_dwRef;
};
CServer m_Server;

// Template class that provides basic IUnknown implementation
template <class T, const IID* piid>
class CInterface : public T
{
public:
  CInterface() : m_dwRef(0)
  { m_Server.m_dwRef++; }
  virtual ~CInterface()
  { m_Server.m_dwRef--; }

  STDMETHOD(QueryInterface)(REFIID riid, void** ppvObject)
  {
    if ((riid == IID_IUnknown) || (riid == *piid))
    {
      *ppvObject = (T*)static_cast<T*>(this);
      m_dwRef++;
      return S_OK;
    }
    return E_NOINTERFACE;
  }
  STDMETHOD_(ULONG,AddRef)()
  { return ++m_dwRef; }
  STDMETHOD_(ULONG,Release)()
  {
    if (!(--m_dwRef))
    {
		try {
		  void* This;
		  This=this;
		  delete This;
		  throw 1;
		} catch (int i) {i=0;}
      return 0;
    }
    return m_dwRef;
  }
  DWORD m_dwRef;
};

// The COM class
class ComClass : public CInterface<IDispatch,&IID_IDispatch>
{
// IDispatch interface implementation
public:
    // These methods not implemented
    STDMETHOD(GetTypeInfoCount)(UINT* pctinfo)
    { return E_NOTIMPL;  }
    STDMETHOD(GetTypeInfo)(UINT, LCID, ITypeInfo**)
    { return E_NOTIMPL;  }

    //Method definition
    STDMETHOD(GetIDsOfNames)(REFIID, LPOLESTR* rgszNames,
               UINT cNames, LCID, DISPID* rgDispId)
    {
      return COM_GetIDsOfNames(rgszNames, cNames, rgDispId, data);
    }

    //Method Invoke
    STDMETHOD(Invoke)(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr)
    {
      return COM_Invoke(dispIdMember, riid, lcid, wFlags,
         pDispParams, pVarResult, pExcepInfo, puArgErr, data);
    }
	ComClass(int COM_ID){
		data=new COMDATA(COM_ID,this);
		RegisterComData(data);
	}
	~ComClass(){
		if (data->ParentComClass=this) {
			if (data->ParentData) {
				for (int i=0;i<data->ParentData->CompoNum;i++) {
					if (data->ParentData->ChildComClass[i]==this) data->ParentData->ChildComClass[i]=0;
				}
			}
			DeleteComData(data);
			delete data;
		}
	}
    COMDATA* data;
};

//IDidpatch handling for getting data from object.
COMDATA* GetDataFromComClass(IDispatch* pDisp){
	ComClass* temp=(ComClass*)pDisp;
	return temp->data;
}
// Class factory to create COM objects
class CClassFactory :
  public CInterface<IClassFactory,&IID_IClassFactory>
{
public:
// IClassFactory interface implementation
  STDMETHOD(CreateInstance)(IUnknown* pUnkOuter, REFIID riid,
                void** ppvObject)
  {
    if (pUnkOuter)
      return CLASS_E_NOAGGREGATION;
    ComClass* pObject = new ComClass(com_id);
    HRESULT hr = pObject->QueryInterface(riid,ppvObject);
    if (FAILED(hr))
      delete pObject;
    return hr;
  }
  STDMETHOD(LockServer)(BOOL fLock)
  { return CoLockObjectExternal(this,fLock,TRUE); }
  CClassFactory(int COM_ID){com_id=COM_ID;}
private:
  int com_id;
};

//CreateObject
IDispatch* NewComClass(int COM_ID){
	IClassFactory* ppv;
	IDispatch* ppvObject;
	DllGetClassObject(CLSID_COM(COM_ID),IID_IClassFactory,(LPVOID*)&ppv);
	ppv->QueryInterface(IID_IClassFactory, (void**) &ppv);
	ppv->Release();
	ppv->CreateInstance(NULL,IID_IUnknown,(void**)&ppvObject);
	ppv->Release();
	ppvObject->QueryInterface(IID_IDispatch,(void**)&ppvObject);
	ppvObject->Release();
	return ppvObject;
}

//GUID and registry handling
inline char hex(unsigned int i, int position){
	return "0123456789ABCDEF"[(i>>(position*4))&15];
}
char* clsidval(GUID guid,char* buff){
	int i,j;
	for (i=0;i<8;i++) buff[8-i]=hex(guid.Data1,i);
	for (i=0;i<4;i++) buff[13-i]=hex(guid.Data2,i);
	for (i=0;i<4;i++) buff[18-i]=hex(guid.Data3,i);
	for (i=0;i<2;i++) for (j=0;j<2;j++) buff[21+i*2-j]=hex(guid.Data4[i],j);
	for (i=2;i<8;i++) for (j=0;j<2;j++) buff[22+i*2-j]=hex(guid.Data4[i],j);
	return buff;
}

char _clsid[39]="{xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}";
char* clsidval(GUID guid){
	return clsidval(guid,_clsid);
}
char _clsidkey[45]="CLSID\\{xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}";
char* clsidkey(GUID guid){
	clsidval(guid,_clsidkey+6);
	return _clsidkey;
}
char _classkey[60]="CLSID\\{xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}\\InProcServer32";
char* classkey(GUID guid){
	clsidval(guid,_classkey+6);
	return _classkey;
}

char* _prodidkey=0;
char* prodidkey(LPCSTR prodkey){
	int i,j;
	delete _prodidkey;
	_prodidkey=new char[strlen(prodkey)+7];
	for (i=0;_prodidkey[i]=prodkey[i];i++);
	for (j=0;_prodidkey[i++]="\\CLSID"[j];j++);
	return _prodidkey;
}

// Required COM in-proc server exports
STDAPI DllUnregisterServer(void)
{
	for (int i=0;i<COM_NUM;i++){
		HRESULT hr = S_OK;
		HKEY key = NULL;
		if (!RegCreateKeyExA(HKEY_CLASSES_ROOT,clsidkey(CLSID_COM(i)),0,NULL,REG_OPTION_NON_VOLATILE,
							KEY_ALL_ACCESS,NULL,&key,NULL))
		{
			char szModulePath[_MAX_PATH];
			GetModuleFileNameA(m_Server.m_hInstance,szModulePath,_MAX_PATH);
			if(!RegSetValueExA(key,NULL,0,REG_SZ,(const unsigned char*)szModulePath,
							  strlen(szModulePath)+1))
			{
			  if (!RegCreateKeyExA(HKEY_CLASSES_ROOT,PRODKEY(i),0,NULL,REG_OPTION_NON_VOLATILE,
								KEY_ALL_ACCESS,NULL,&key,NULL))
			  {
				if (RegDeleteKeyA(HKEY_CLASSES_ROOT,prodidkey(PRODKEY(i)))) hr = E_FAIL;
				if (RegDeleteKeyA(HKEY_CLASSES_ROOT,PRODKEY(i))) hr = E_FAIL;
			  }
			  RegCloseKey(key);
			}
			if (RegDeleteKeyA(HKEY_CLASSES_ROOT,classkey(CLSID_COM(i)))) hr = E_FAIL;
			if (RegDeleteKeyA(HKEY_CLASSES_ROOT,clsidkey(CLSID_COM(i)))) hr = E_FAIL;
		}
		RegCloseKey(key);
		if (hr == E_FAIL) return hr;
	}
    return S_OK;
}

char szModulePath[_MAX_PATH];
LPSTR ModulePath(){
	GetModuleFileNameA(m_Server.m_hInstance,szModulePath,_MAX_PATH);
	return szModulePath;
}

STDAPI DllRegisterServer(void)
{
	LPSTR szModulePath=ModulePath();
	for (int i=0;i<COM_NUM;i++){
		HRESULT hr = E_FAIL;
		HKEY key = NULL;
		if (!RegCreateKeyExA(HKEY_CLASSES_ROOT,classkey(CLSID_COM(i)),0,NULL,REG_OPTION_NON_VOLATILE,
							KEY_ALL_ACCESS,NULL,&key,NULL))
		{
			if(!RegSetValueExA(key,NULL,0,REG_SZ,(unsigned char*)szModulePath,
							  strlen(szModulePath)+1))
			{
			  RegCloseKey(key);
			  if (!RegCreateKeyExA(HKEY_CLASSES_ROOT,prodidkey(PRODKEY(i)),0,NULL,REG_OPTION_NON_VOLATILE,
								KEY_ALL_ACCESS,NULL,&key,NULL))
			  {
				if (!RegSetValueExA(key,NULL,0,REG_SZ,(const unsigned char*)clsidval(CLSID_COM(i)),
							  strlen(clsidval(CLSID_COM(i)))+1))
				  hr = S_OK;
			  }
			}
		}
		RegCloseKey(key);
		if (hr == E_FAIL) return hr;
	}
    return S_OK;
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	HRESULT hr = CLASS_E_CLASSNOTAVAILABLE;
	for (int i=0;i<COM_NUM;i++)
		if (rclsid == CLSID_COM(i)){
			CClassFactory* pFactory = new CClassFactory(i);
			if (pFactory!=NULL) {
				hr = pFactory->QueryInterface(riid,ppv);
				if (FAILED(hr)) {
					pFactory->Release();
				}
			}
			break;
		}
	return hr;
}

STDAPI DllCanUnloadNow()
{ return (m_Server.m_dwRef) ? S_FALSE : S_OK; }

// DllMain
extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	int i;
	switch(dwReason) {
	case DLL_PROCESS_ATTACH:
		m_Server.m_hInstance = hInstance;
		DisableThreadLibraryCalls(hInstance);
		break;
	case DLL_PROCESS_DETACH:
		for (i=0;i<NumComDatas;i++) DeleteComData(ComDatas[i]);
		break;
	default:
		break;
	}
	return TRUE;
}
