#include "common.h"

char* HexTemp="00000000\0";
char* HEX(int i){
	for (int j=0;j<8;j++) HexTemp[7-j]="0123456789ABCDEF"[(i>>j*4)&15];
	return HexTemp;
}

int GetIntFromUnicode(LPWSTR Unicode){
	LPWSTR buff=L"0123456789";
	int ret=0;
	int i,j;
	LPWSTR c;
	for (i=0;c=wcsrchr(buff, Unicode[i]);i++) {
		j=(int)(c-buff);
		if (0<=j && j<=9) ret=ret*10+j;
		else break;
	}
	return ret;
}

LPWSTR CreateFixedLengthUnicode(LPSTR ANSI,COMDATA* data, int length, enum MALLOC_TYPE temporary){
	//Convert ANSI to Unicode
	LPWSTR Unicode2=(LPWSTR)(4+(int)data->Malloc(length*2+6,temporary));
	if (ANSI) MultiByteToWideChar(CP_ACP,0,ANSI,-1,Unicode2,length);
	int* lpInt=(int*)((int)Unicode2-4);
	*lpInt=length*2;
	return Unicode2;
}

LPWSTR CreateFixedLengthUnicode(LPWSTR Unicode,COMDATA* data, int length, enum MALLOC_TYPE temporary){
	//Copy Unicode
	LPWSTR Unicode2=(LPWSTR)(4+(int)data->Malloc(length*2+6,temporary));
	if (Unicode) for (int i=0;i<length;i++) Unicode2[i]=Unicode[i];
	int* lpInt=(int*)((int)Unicode2-4);
	*lpInt=length*2;
	return Unicode2;
}

LPWSTR CreateUnicode(LPSTR ANSI,COMDATA* data, enum MALLOC_TYPE temporary)
{
	if (!ANSI) return 0;
	//Convert ANSI to Unicode
	int BuffLen=MultiByteToWideChar(CP_ACP,0,ANSI,-1,0,0);
	LPWSTR Unicode2=(LPWSTR)(4+(int)data->Malloc(BuffLen*2+6,temporary));
	MultiByteToWideChar(CP_ACP,0,ANSI,-1,Unicode2,BuffLen);
	int* lpInt=(int*)((int)Unicode2-4);
	*lpInt=BuffLen*2-2;
	return Unicode2;
}

LPWSTR CreateUnicode(LPWSTR Unicode,COMDATA* data, enum MALLOC_TYPE temporary)
{
	if (!Unicode) return 0;	
	//Copy Unicode
	int BuffLen=wcslen(Unicode);
	LPWSTR Unicode2=(LPWSTR)(4+(int)data->Malloc(BuffLen*2+6,temporary));
	wcscpy_s(Unicode2,BuffLen+1,Unicode);
	int* lpInt=(int*)((int)Unicode2-4);
	*lpInt=BuffLen*2;
	return Unicode2;
}

char* CreateAnsiString(LPWSTR Unicode,COMDATA* data, enum MALLOC_TYPE temporary)
{
	if (!Unicode) return 0;	
	//determine the length
	int StrLen=WideCharToMultiByte(CP_ACP,0,Unicode,-1,NULL,0,NULL,NULL)+1;
	int BuffLen=wcslen(Unicode)+1;
	if (StrLen<BuffLen) StrLen=BuffLen;
	char* str=(char*)data->Malloc(StrLen+1,temporary);

	//get ANSI string
	WideCharToMultiByte(CP_ACP,0,Unicode,-1,str,StrLen,NULL,NULL);

	return str;
}

char* CreateAnsiString(LPSTR ANSI,COMDATA* data, enum MALLOC_TYPE temporary)
{
	if (!ANSI) return 0;	
	//Copy ANSI
	int StrLen=strlen(ANSI);
	char* str=(char*)data->Malloc(StrLen+1,temporary);
	strcpy_s(str,StrLen+1,ANSI);
	return str;
}

int GetDataFromObject(IDispatch* pDisp, int* i, LPWSTR param){
	LPOLESTR* rgszNames=new LPOLESTR;
	DISPID* rgDispId=new DISPID;
	DISPPARAMS* pDispParams=new DISPPARAMS;
	VARIANT* pVarResult=new VARIANT;
	pDispParams->rgdispidNamedArgs = NULL;
	pDispParams->cNamedArgs = 0;
	pDispParams->cArgs=0;
	int ret=pDisp->Invoke(0, GUID_NULL, NULL, DISPATCH_METHOD,pDispParams, pVarResult,NULL, NULL);
	if (ret==S_OK) {
		//SfcMini.Structure object
	} else {
		//Other object (supporsed to have "Address" method).
		rgszNames[0]=L"Address";
		ret=pDisp->GetIDsOfNames(GUID_NULL, rgszNames,1, NULL, rgDispId);
		if (ret==S_OK) ret=pDisp->Invoke(rgDispId[0], GUID_NULL, NULL, DISPATCH_METHOD,pDispParams, pVarResult,NULL, NULL);
	}
	if (ret==S_OK) ret=ResolveInt(pVarResult,i);
	delete pDispParams;
	delete pVarResult;
	delete rgszNames;
	delete rgDispId;
	return ret;
}

int ResolveInt(VARIANTARG* rgvarg, int* i)
{
  if (rgvarg->vt==VT_I1 || rgvarg->vt==VT_UI1) *i=(int)rgvarg->bVal;
  else if (rgvarg->vt==VT_I2 || rgvarg->vt==VT_UI2) *i=(int)rgvarg->iVal;
  else if (rgvarg->vt==VT_I4 || rgvarg->vt==VT_UI4) *i=(int)rgvarg->lVal;
  else if (rgvarg->vt==VT_R4) *i=(int)rgvarg->fltVal;
  else if (rgvarg->vt==VT_R8) *i=(int)rgvarg->dblVal;
  else if (rgvarg->vt==VT_BOOL) *i=(int)rgvarg->boolVal;
  else if (rgvarg->vt==VT_EMPTY) { *i=0; return VT_I4; }
  else if (rgvarg->vt==VT_DISPATCH) { 
	//When VT_DISPATCH
	//Get information through IDispatch object
	return GetDataFromObject(rgvarg->pdispVal,i,L"Address");
  } else if (rgvarg->vt & VT_BYREF) {
	if (rgvarg->pvarVal->vt==VT_I1 || rgvarg->pvarVal->vt==VT_UI1) *i=(int)rgvarg->pvarVal->bVal;
	else if (rgvarg->pvarVal->vt==VT_I2 || rgvarg->pvarVal->vt==VT_UI2) *i=(int)rgvarg->pvarVal->iVal;
	else if (rgvarg->pvarVal->vt==VT_I4 || rgvarg->pvarVal->vt==VT_UI4) *i=(int)rgvarg->pvarVal->lVal;
    else if (rgvarg->pvarVal->vt==VT_R4) *i=(int)rgvarg->pvarVal->fltVal;
    else if (rgvarg->pvarVal->vt==VT_R8) *i=(int)rgvarg->pvarVal->dblVal;
	else if (rgvarg->pvarVal->vt==VT_BOOL) *i=(int)rgvarg->pvarVal->boolVal;
	else if (rgvarg->pvarVal->vt==VT_EMPTY) { *i=0; return VT_I4; }
	else if (rgvarg->pvarVal->vt==VT_DISPATCH) { 
		//When VT_DISPATCH
		//Get information through IDispatch object
		return GetDataFromObject(rgvarg->pvarVal->pdispVal,i,L"Address");
	} else return 0;
	return rgvarg->pvarVal->vt;
  } else return 0;
  return rgvarg->vt;
}

int ResolveFloat(VARIANTARG* rgvarg, double* d)
{
  if (rgvarg->vt==VT_I1 || rgvarg->vt==VT_UI1) *d=(double)rgvarg->bVal;
  else if (rgvarg->vt==VT_I2 || rgvarg->vt==VT_UI2) *d=(double)rgvarg->iVal;
  else if (rgvarg->vt==VT_I4 || rgvarg->vt==VT_UI4) *d=(double)rgvarg->lVal;
  else if (rgvarg->vt==VT_R4) *d=(double)rgvarg->fltVal;
  else if (rgvarg->vt==VT_R8) *d=(double)rgvarg->dblVal;
  else if (rgvarg->vt==VT_BOOL) *d=(double)rgvarg->boolVal;
  else if (rgvarg->vt==VT_EMPTY) { *d=0; return VT_I4; }
  else if (rgvarg->vt & VT_BYREF) {
	if (rgvarg->pvarVal->vt==VT_I1 || rgvarg->pvarVal->vt==VT_UI1) *d=(double)rgvarg->pvarVal->bVal;
	else if (rgvarg->pvarVal->vt==VT_I2 || rgvarg->pvarVal->vt==VT_UI2) *d=(double)rgvarg->pvarVal->iVal;
	else if (rgvarg->pvarVal->vt==VT_I4 || rgvarg->pvarVal->vt==VT_UI4) *d=(double)rgvarg->pvarVal->lVal;
    else if (rgvarg->pvarVal->vt==VT_R4) *d=(double)rgvarg->pvarVal->fltVal;
    else if (rgvarg->pvarVal->vt==VT_R8) *d=(double)rgvarg->pvarVal->dblVal;
	else if (rgvarg->pvarVal->vt==VT_BOOL) *d=(double)rgvarg->pvarVal->boolVal;
	else if (rgvarg->pvarVal->vt==VT_EMPTY) { *d=0; return VT_I4; }
	else return 0;
	return rgvarg->pvarVal->vt;
  } else return 0;
  return rgvarg->vt;
}

BOOL ResolveUnicode(VARIANTARG* rgvarg, LPWSTR* Unicode)
{
  if (rgvarg->vt==VT_BSTR) *Unicode=rgvarg->bstrVal;
  else if (rgvarg->vt==VT_EMPTY) *Unicode=0;
  else if (rgvarg->vt & VT_BYREF) {
	if (rgvarg->pvarVal->vt==VT_BSTR) *Unicode=rgvarg->pvarVal->bstrVal;
	else if (rgvarg->pvarVal->vt==VT_EMPTY) *Unicode=0;
	else return FALSE;
  } else return FALSE;
  return TRUE;
}

BOOL ResolveDispatch(VARIANTARG* rgvarg, IDispatch** pDisp)
{
	if (rgvarg->vt==VT_DISPATCH) {
		*pDisp=rgvarg->pdispVal;
		return TRUE;
	} else if (rgvarg->vt & VT_BYREF) {
		if (rgvarg->pvarVal->vt==VT_DISPATCH) {
			*pDisp=rgvarg->pvarVal->pdispVal;
			return TRUE;
		}
	}
	return FALSE;
}