#include "common.h"

//Method definition
DWORD ClassEx_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
	int i,ret;
	LPOLESTR* rgszNames2=new LPOLESTR;
	DISPID* rgDispId2=new DISPID;
	for (i=0;i<(int)cNames;i++)
	{
		if (!lstrcmpiW(rgszNames[i],L"Register") && (!data->pDisp || !data->pDisp2)) {
			rgDispId[i]=0;
			delete rgszNames2;
			delete rgDispId2;
			return S_OK;
		}
		// Check if pDisp and pDisp2 are defined.
		if (!data->pDisp || !data->pDisp2) return DISP_E_MEMBERNOTFOUND;
		// These are defined. Check properties of each objects.
		rgszNames2[0]=rgszNames[i];
		ret=data->pDisp->GetIDsOfNames(GUID_NULL, rgszNames2,1, NULL, rgDispId2);
		if (ret==S_OK) data->UseDisp2=FALSE;
		else {
			ret=data->pDisp2->GetIDsOfNames(GUID_NULL, rgszNames2,1, NULL, rgDispId2);
			if (ret!=S_OK) {
				delete rgszNames2;
				delete rgDispId2;
				return DISP_E_MEMBERNOTFOUND;
			}
			data->UseDisp2=TRUE;
		}
		rgDispId[i]=rgDispId2[0];
	}
	delete rgszNames2;
	delete rgDispId2;
	return S_OK;
}

//Method Invoke
DWORD ClassEx_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
	LPWSTR Unicode;
	int cArgs = pDispParams->cArgs;
	VARIANTARG* rgvarg = pDispParams->rgvarg;

	switch (dispIdMember)
	{
	case 0:	//Declare
		if (cArgs==1) {
			// One argument. Currenly, only "Reset" is implemented.
			if (!ResolveUnicode(&rgvarg[0],&Unicode)) return DISP_E_BADPARAMCOUNT;
			if (lstrcmpiW(Unicode,L"Reset"))          return DISP_E_BADPARAMCOUNT;
			// Reset data
			data->Reset();
			return S_OK;
		} else if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
		if (!ResolveDispatch(&rgvarg[0],&data->pDisp2)) return DISP_E_BADPARAMCOUNT;
		if (!ResolveDispatch(&rgvarg[1],&data->pDisp)) return DISP_E_BADPARAMCOUNT;
		return S_OK;
	default: //forward to child IDispatch
		if (data->UseDisp2) return data->pDisp2->Invoke(dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr);
		else return data->pDisp->Invoke(dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr);
	}
}
