#include "common.h"

//Call back stuffs follow
DWORD _stdcall CallBack(COMDATA* data, int* params){
	//Generic call-back function with enabled access to COMDATA class.
	//The COMDATA contains pDisp object that can be called by Invoke method.
	//The "int params" points the stack address of parameters.
	int i;
	int* lVal;
	DISPPARAMS* pDispParams;
	VARIANT* pVarResult;
	pDispParams=new DISPPARAMS;
	pVarResult=new VARIANT;
	pDispParams->rgdispidNamedArgs = NULL;
	pDispParams->cNamedArgs = 0;
	pDispParams->cArgs=data->CallBackParamNum;
	pDispParams->rgvarg=new VARIANTARG[data->CallBackParamNum];
	for (i=0;i<data->CallBackParamNum;i++){
		lVal=(int*)((int)params+i*4);//The pointer is set to stack position of params (+alpha).
		pDispParams->rgvarg[data->CallBackParamNum-1-i].vt=VT_I4;
		pDispParams->rgvarg[data->CallBackParamNum-1-i].lVal=*lVal;
	}
	data->pDisp->Invoke(data->rgDispId, GUID_NULL, NULL, DISPATCH_METHOD,pDispParams, pVarResult,NULL, NULL);
	i=pVarResult->lVal;
	delete [] pDispParams->rgvarg;
	delete pDispParams;
	delete pVarResult;
	return i;
}

COMDATA* dataForCallBack[11]={0,0,0,0,0,0,0,0,0,0,0};

// Actually, following functions are first called as the call-back function.
// The precess then goes to the above CallBack function.
// There only ten resources for call back functions
DWORD _stdcall PreCallBack1(int params){ return CallBack(dataForCallBack[1], &params); }
DWORD _stdcall PreCallBack2(int params){ return CallBack(dataForCallBack[2], &params); }
DWORD _stdcall PreCallBack3(int params){ return CallBack(dataForCallBack[3], &params); }
DWORD _stdcall PreCallBack4(int params){ return CallBack(dataForCallBack[4], &params); }
DWORD _stdcall PreCallBack5(int params){ return CallBack(dataForCallBack[5], &params); }
DWORD _stdcall PreCallBack6(int params){ return CallBack(dataForCallBack[6], &params); }
DWORD _stdcall PreCallBack7(int params){ return CallBack(dataForCallBack[7], &params); }
DWORD _stdcall PreCallBack8(int params){ return CallBack(dataForCallBack[8], &params); }
DWORD _stdcall PreCallBack9(int params){ return CallBack(dataForCallBack[9], &params); }
DWORD _stdcall PreCallBack10(int params){return CallBack(dataForCallBack[10],&params); }
//The 11th is a temporaly call back function.
//This must be used imediately after the decralation
DWORD _stdcall PreCallBack11(int params){return CallBack(dataForCallBack[0], &params); }

void ReleaseCallBackFunction(int i){// This is called by COMDATA class destractor.
	if (0<i && i<11) dataForCallBack[i]=0;
}
void* SelectCallBackFunction(COMDATA* data){
	int i;
	if (0<data->ReservedCallBackFunction && data->ReservedCallBackFunction<11) {
		dataForCallBack[data->ReservedCallBackFunction]=data;		
		switch(data->ReservedCallBackFunction){
			case 1:  return (void*)*PreCallBack1;
			case 2:  return (void*)*PreCallBack2;
			case 3:  return (void*)*PreCallBack3;
			case 4:  return (void*)*PreCallBack4;
			case 5:  return (void*)*PreCallBack5;
			case 6:  return (void*)*PreCallBack6;
			case 7:  return (void*)*PreCallBack7;
			case 8:  return (void*)*PreCallBack8;
			case 9:  return (void*)*PreCallBack9;
			default: return (void*)*PreCallBack10;
		}
	}
	for (i=1;i<11;i++) {
		if (dataForCallBack[i]!=0) continue;
		data->ReservedCallBackFunction=i;
		dataForCallBack[i]=data;
		switch(i){
			case 1:  return (void*)*PreCallBack1;
			case 2:  return (void*)*PreCallBack2;
			case 3:  return (void*)*PreCallBack3;
			case 4:  return (void*)*PreCallBack4;
			case 5:  return (void*)*PreCallBack5;
			case 6:  return (void*)*PreCallBack6;
			case 7:  return (void*)*PreCallBack7;
			case 8:  return (void*)*PreCallBack8;
			case 9:  return (void*)*PreCallBack9;
			default: return (void*)*PreCallBack10;
		}
	}
	data->ReservedCallBackFunction=0;
	dataForCallBack[0]=data;
	return (void*)*PreCallBack11;
}
