option explicit
Execute WScript.CreateObject("SfcMini.tools").Include("<WinForm.vbs>")
Execute WScript.CreateObject("SfcMini.tools").Include("<Structures\PAINTSTRUCT.vbs>")

Dim PrevPoint_x,PrevPoint_y
Dim Point_x()
Dim Point_y()
Dim NumPoint
NumPoint=0

Dim Form1,API
Set Form1=new WinForm
Set API=Form1.API
With Form1
.WindowClass.hbrBackground = COLOR_WINDOW +1
.TrackMsg WM_LBUTTONDOWN,0
.TrackMsg WM_LBUTTONUP,0
.TrackMsg WM_MOUSEMOVE,0
.TrackMsg WM_PAINT,0
.TrackMsg WM_DESTROY,0
.SetWndProc("WndProc")
.Init
.Show
End With

WScript.Quit(Form1.MsgLoop)

Function WndProc(hwnd,message,wparam,lparam)
  select case message
  case WM_LBUTTONDOWN
    WndProc=Wm_LButtonDownProc(hwnd,wparam,LOWORD(lparam),HIWORD(lparam))
  case WM_LBUTTONUP
    WndProc=Wm_LButtonUpProc(hwnd,wparam,LOWORD(lparam),HIWORD(lparam))
  case WM_MOUSEMOVE
    WndProc=Wm_MouseMoveProc(hwnd,wparam,LOWORD(lparam),HIWORD(lparam))
  case WM_PAINT
    WndProc=Wm_PaintProc(hwnd)
  case WM_DESTROY
    Call API.PostQuitMessage(0)
    WndProc=0
  end select
End Function

Function Wm_LButtonDownProc(hwnd,wparam,xPos,yPos)
  API.SetCapture(hwnd)
  PrevPoint_x=xPos
  PrevPoint_y=yPos

  Redim Preserve Point_x(NumPoint+2)
  Redim Preserve Point_y(NumPoint+2)
  NumPoint=NumPoint+1
  Point_x(NumPoint)=-1
  Point_y(NumPoint)=-1
  NumPoint=NumPoint+1
  Point_x(NumPoint)=xPos
  Point_y(NumPoint)=yPos
End Function

Function Wm_LButtonUpProc(hwnd,wparam,xPos,yPos)
  Dim DC
  if API.GetCapture=hwnd then
    API.ReleaseCapture()
    DC=API.GetDC(hwnd)
    Call API.MoveToEx(DC,PrevPoint_x,PrevPoint_y,0)
    Call API.LineTo(DC,xPos,yPos)
    Call API.ReleaseDC(hwnd,DC)

    Redim Preserve Point_x(NumPoint+2)
    Redim Preserve Point_y(NumPoint+2)
    NumPoint=NumPoint+1
    Point_x(NumPoint)=xPos
    Point_y(NumPoint)=yPos
    NumPoint=NumPoint+1
    Point_x(NumPoint)=-1
    Point_y(NumPoint)=-1
  end if
End Function

Function Wm_MouseMoveProc(hwnd,wparam,xPos,yPos)
  Dim DC
  if API.GetCapture=hwnd then

    DC=API.GetDC(hwnd)
    Call API.MoveToEx(DC,PrevPoint_x,PrevPoint_y,0)
    Call API.LineTo(DC,xPos,yPos)
    Call API.ReleaseDC(hwnd,DC)

    PrevPoint_x=xPos
    PrevPoint_y=yPos

    Redim Preserve Point_x(NumPoint+1)
    Redim Preserve Point_y(NumPoint+1)
    NumPoint=NumPoint+1
    Point_x(NumPoint)=xPos
    Point_y(NumPoint)=yPos

  end if
End Function

Function Wm_PaintProc(hwnd)
  Dim i,hPaintDC
  hPaintDC = API.BeginPaint(hWnd, PAINTSTRUCT)
  for i=2 to NumPoint
    if 0<=Point_x(i) and 0<=Point_y(i) then
      if Point_x(i-1)<0 or Point_y(i-1)<0 then
        Call API.MoveToEx(hPaintDC,Point_x(i),Point_y(i),0)
      else
        Call API.LineTo(hPaintDC,Point_x(i),Point_y(i))
      end if
    end if
  next
  Call API.EndPaint(hWnd, PAINTSTRUCT)
End Function
