'************************************
'* CreateBlockingWinSock() function *
'************************************

'on error resume next

execute "Const INADDR_LOOPBACK = &H7f000001"
execute "Const INADDR_BROADCAST = &HFFFFFFFF"
execute "Const INADDR_NONE = &HFFFFFFFF"
execute "Const INADDR_ANY = &H0"
execute "Const AF_INET = 2"
execute "Const SOCK_STREAM = 1"
execute "Const IPPROTO_IP=0"
execute "Const IPPROTO_ICMP=1"
execute "Const IPPROTO_GGP=2"
execute "Const IPPROTO_TCP=6"
execute "Const IPPROTO_PUP=12"
execute "Const IPPROTO_UDP=17"
execute "Const IPPROTO_IDP=22"
execute "Const IPPROTO_ND=77"
execute "Const IPPROTO_RAW=255"
execute "Const IPPROTO_MAX=256"
execute "Const WSA_FLAG_OVERLAPPED = &H1"
execute "Const INVALID_SOCKET = -1"
execute "Const SOCKET_ERROR = -1"
execute "Const SD_RECEIVE = 0"
execute "Const SD_SEND = 1"
execute "Const SD_BOTH = 2"
execute "Const SO_DEBUG        =&H0001"
execute "Const SO_ACCEPTCONN   =&H0002"
execute "Const SO_REUSEADDR    =&H0004"
execute "Const SO_KEEPALIVE    =&H0008"
execute "Const SO_DONTROUTE    =&H0010"
execute "Const SO_BROADCAST    =&H0020"
execute "Const SO_USELOOPBACK  =&H0040"
execute "Const SO_LINGER       =&H0080"
execute "Const SO_OOBINLINE    =&H0100"
execute "Const SO_DONTLINGER   =&HFF7F&"
execute "Const SO_SNDBUF       =&H1001"
execute "Const SO_RCVBUF       =&H1002"
execute "Const SO_SNDLOWAT     =&H1003"
execute "Const SO_RCVLOWAT     =&H1004"
execute "Const SO_SNDTIMEO     =&H1005"
execute "Const SO_RCVTIMEO     =&H1006"
execute "Const SO_ERROR        =&H1007"
execute "Const SO_TYPE         =&H1008"
execute "Const SO_CONNDATA     =&H7000"
execute "Const SO_CONNOPT      =&H7001"
execute "Const SO_DISCDATA     =&H7002"
execute "Const SO_DISCOPT      =&H7003"
execute "Const SO_CONNDATALEN  =&H7004"
execute "Const SO_CONNOPTLEN   =&H7005"
execute "Const SO_DISCDATALEN  =&H7006"
execute "Const SO_DISCOPTLEN   =&H7007"
execute "Const SO_OPENTYPE     =&H7008"
execute "Const SO_SYNCHRONOUS_ALERT    =&H10"
execute "Const SO_SYNCHRONOUS_NONALERT =&H20"
execute "Const SO_MAXDG        =&H7009"
execute "Const SO_MAXPATHDG    =&H700A"
execute "Const SOL_SOCKET      =&Hffff&"
execute "Const TCP_NODELAY     =&H0001"
execute "Const TCP_BSDURGENT   =&H7000"
execute "Const FIONREAD = &H8004667F"
execute "Const FIONBIO = &H8004667E"
execute "Const FIOASYNC = &H8004667D"

on error goto 0

dim SFC_CreateBlockingWinSock()
dim SFC_CreateBlockingWinSockNum
function CreateBlockingWinSock()
  dim temp,temp2
  SFC_CreateBlockingWinSockNum=cInt(SFC_CreateBlockingWinSockNum)
  redim preserve SFC_CreateBlockingWinSock(SFC_CreateBlockingWinSockNum)
  set SFC_CreateBlockingWinSock(SFC_CreateBlockingWinSockNum)=new WinSockB
  set CreateBlockingWinSock=SFC_CreateBlockingWinSock(SFC_CreateBlockingWinSockNum).this
  SFC_CreateBlockingWinSockNum=SFC_CreateBlockingWinSockNum+1
end function

'******************
'* WinSockB Class *
'******************
Class WinSockB
public API,this
public WSADATA
public sockaddr_in
private sockaddr_in_Len
public fd_set,hostent,servent,protoent

private sub Class_Initialize()
  set API=WScript.CreateObject("SfcMini.DynaCall").LoadLibraries("wsock32.dll","kernel32")
  set this=WScript.CreateObject("SfcMini.ClassEx")
  call this(Me,Me.API)
  set WSADATA=WScript.CreateObject("SfcMini.Structure")
  WSADATA _
    "wVersion","Long", _
    "wHighVersion","Long", _
    "szDescription","String*257", _
    "szSystemStatus","String*129", _
    "iMaxSockets","Integer", _
    "iMaxUdpDg","Integer", _
    "lpVendorInfo","Long"
  if API.WSAStartup(&h101,WSADATA)<>0 then
    msgbox "WSAStartup() falied"
    wscript.quit
  end if
  set sockaddr_in=WScript.CreateObject("SfcMini.Structure")
  sockaddr_in _
    "sin_family","Integer", _
    "sin_port","Integer", _
    "sin_addr","Long", _
    "sin_zero","String*8"
  sockaddr_in_Len=WScript.CreateObject("SfcMini.tools").Len(sockaddr_in)
  set fd_set=WScript.CreateObject("sfcmini.structure")("fd_count","Long","fd_array(63)","Long")
  set hostent=WScript.CreateObject("SfcMini.Structure")
  hostent _
    "h_name","Long", _
    "h_aliases","Long", _
    "h_addrtype","Integer", _
    "h_length","Integer", _
    "h_addr_list","Long"
  set servent=WScript.CreateObject("SfcMini.Structure")
  servent _
    "s_name","Long", _
    "s_aliases","Long", _
    "s_port","Integer", _
    "s_proto","Long"
  set protoent=WScript.CreateObject("SfcMini.Structure")
  protoent _
    "p_name","Long", _
    "p_aliases","Long", _
    "p_proto","Integer"
end sub

private sub Class_Terminate()
  call API.WSACleanup()
end sub

'resolve String from LPSTR (not Shift-JIS compatible)
function GetAnsiString(lpString)
  dim i,b
  if lpString=0 then exit function
  set b=WScript.CreateObject("SfcMini.Structure")("val","Byte")
  i=0
  GetAnsiString=""
  do
    call API.RtlMoveMemory(b,lpString+i,1)
    if b.val=0 then exit do
    GetAnsiString=GetAnsiString+chr(b.val)
    i=i+1
  loop
end function

'*** Overriding methods follow ***

function bind(s)
  bind=API.bind(s,sockaddr_in,sockaddr_in_Len)
end function

function connect(s)
  connect=API.connect(s,sockaddr_in,sockaddr_in_Len)
end function

function accept(s)
  dim namelen
  set namelen=WScript.CreateObject("SfcMini.Structure")("val","Long")
  namelen.val=sockaddr_in_Len
  accept=API.accept(s,sockaddr_in,namelen)
end function

'returns String
function getprotobynumber(protocol)
  dim ret
  ret=API.getprotobynumber(protocol)
  if ret then
    call API.RtlMoveMemory(protoent,ret,10)
    getprotobynumber=GetAnsiString(protoent.p_name)
  else
    getprotobynumber=empty
  end if
end function

'returns Integer
function getprotobyname(protocol)
  dim ret
  ret=API.getprotobyname(protocol)
  if ret then
    call API.RtlMoveMemory(protoent,ret,10)
    getprotobyname=protoent.p_proto
  else
    getprotobyname=empty
  end if
end function

'returns Integer
function getservbyname(name)
  dim ret
  ret=API.getservbyname(name,0)
  if ret then
    call API.RtlMoveMemory(servent,ret,14)
    getservbyname=servent.s_port
  else
    getservbyname=empty
  end if
end function

'returns String
function getservbyport(port)
  dim ret
  ret=API.getservbyport(port,0)
  if ret then
    call API.RtlMoveMemory(servent,ret,14)
    getservbyport=GetAnsiString(servent.s_name)
  else
    getservbyport=empty
  end if
end function

'returns String
function inet_ntoa(addr)
  inet_ntoa=GetAnsiString(API.inet_ntoa(addr))
end function

'returns host address as 32bit integer
function gethostbyname(addr)
  dim ret,temp
  set temp=WScript.CreateObject("SfcMini.Structure")("addrList","Long","IP","Long")
  ret=API.gethostbyname(addr)
  if ret then
    call API.RtlMoveMemory(hostent,ret,16)
    call API.RtlMoveMemory(temp,hostent.h_addr_list,4)
    call API.RtlMoveMemory(temp+4,temp.addrList,hostent.h_length)
    gethostbyname=temp.IP
  else
    gethostbyname=INADDR_NONE
  end if
end function

'returns host address as String
function gethostbyaddr(addr)
  dim ret,temp
  set temp=WScript.CreateObject("SfcMini.Structure")("addr","Long")
  temp.addr=addr
  ret=API.gethostbyaddr(temp,4,AF_INET)
  if ret then
    call API.RtlMoveMemory(hostent,ret,16)
    gethostbyaddr=GetAnsiString(hostent.h_name)
  else
    gethostbyaddr=empty
  end if
end function

function gethostname()
  dim temp
  temp=space(256)
  if API.gethostname(temp,256)=SOCKET_ERROR then
    gethostbyaddr=empty
  else
    gethostname=left(temp,instr(1,temp+chr(0),chr(0)))
  end if
end function
function getpeername(s)
  dim namelen
  set namelen=WScript.CreateObject("SfcMini.Structure")("val","Long")
  namelen.val=sockaddr_in_Len
  if API.getpeername(s,sockaddr_in,namelen)=SOCKET_ERROR then
    getpeername=INADDR_NONE
  else
    getpeername=sockaddr_in.sin_addr
  end if
end function
function getsockname(s)
  dim namelen
  set namelen=WScript.CreateObject("SfcMini.Structure")("val","Long")
  namelen.val=sockaddr_in_Len
  if API.getsockname(s,sockaddr_in,namelen)=SOCKET_ERROR then
    getsockname=INADDR_NONE
  else
    getsockname=sockaddr_in.sin_addr
  end if
end function
End Class
'**********************
'* End WinSockB Class *
'**********************
