'****************************
'* Menu & PopupMenu Classes *
'****************************
''Example:
'set MenuClass=New Menu
'set PopupMenuClass1=New PopupMenu
'set PopupMenuClass2=New PopupMenu
'Call MenuClass.AppendPopupMenu(PopupMenuClass1.hMenu,"Menu")
'Call PopupMenuClass1.AppendMenu(11,"1-1")
'Call PopupMenuClass1.AppendMenu(12,"1-2")
'Call PopupMenuClass1.AppendSeparator
'Call PopupMenuClass1.AppendPopupMenu(PopupMenuClass2.hMenu,"2nd Menu")
'Call PopupMenuClass2.AppendMenu(21,"2-1")
'Call PopupMenuClass2.AppendMenu(22,"2-2")
'Call MenuClass.SetMenu(hWnd)
''The "11","12","21", and "22" are just examples and used to track commands in WndProc.

On Error Resume Next
execute WScript.CreateObject("SfcMini.tools").Include("<SFC_GetFreeId.vbs>")

execute "Const MF_SEPARATOR = &H800"
execute "Const MF_POPUP = &H10"
execute "Const MF_ENABLED = &H0"
execute "Const MF_STRING = &H0"

On Error Goto 0

Class Menu
private v_hMenu, API
public function hMenu()
  hMenu=v_hMenu
end function
private sub Class_Initialize()
  set API=WScript.CreateObject("SfcMini.DynaCall")
  API.LoadLibraries "user32"
  v_hMenu=API.CreateMenu
end sub
public function AppendPopupMenu(wIDNewItem,lpNewItem)
  Call API.AppendMenuA(hMenu,MF_POPUP,wIDNewItem,lpNewItem)
end function
public Function SetMenu(hwnd)
  Call API.SetMenu(hwnd,hMenu)
  Call API.DrawMenuBar(hwnd)
end function
private sub Class_Terminate()
  API.DestroyMenu(hMenu)
end sub
End Class

Class PopupMenu
private v_hMenu, API
public function hMenu()
  hMenu=v_hMenu
end function
private sub Class_Initialize()
  set API=WScript.CreateObject("SfcMini.DynaCall")
  API.LoadLibraries "user32"
  v_hMenu=API.CreatePopupMenu
end sub
public function AppendMenu(ByVal wIDNewItem,lpNewItem)
  if IsNumeric(wIDNewItem)=false and cstr(wIDNewItem)<>"" then 'Register Event Function
    AppendMenu=SFC_GetFreeId(cstr(wIDNewItem))
    wIDNewItem=AppendMenu
  else
    AppendMenu=cLng(wIDNewItem)
    wIDNewItem=AppendMenu
  end if
  Call API.AppendMenuA(hMenu,MF_ENABLED or MF_STRING,wIDNewItem,lpNewItem)
end function
public function AppendSeparator()
  Call API.AppendMenuA(hMenu,MF_SEPARATOR,0,"")
end function
public function AppendPopupMenu(wIDNewItem,lpNewItem)
  Call API.AppendMenuA(hMenu,MF_POPUP,wIDNewItem,lpNewItem)
end function
private sub Class_Terminate()
  Call API.DestroyMenu(hMenu)
end sub
End Class
'********************************
'* End Menu & PopupMenu Classes *
'********************************
