#include "common.h"

//GetProcAddress stuffs follow
DWORD SubSubGetProcAddress(HINSTANCE hDLL,LPWSTR procName,COMDATA* data)
{
	//Convert unicodes to ANSI strings
  char ANSI[_MAX_PATH];
  WideCharToMultiByte(CP_ACP,0,procName,-1,ANSI,_MAX_PATH,NULL,NULL);
  if (!(data->Address=GetProcAddress(hDLL,ANSI))) {
	  //Search XxxXxxA or XxxXxxW
	  int i;
	  for (i=0;ANSI[i]!=0;i++);
	  if (data->IsUnicode) ANSI[i]='W';
	  else ANSI[i]='A';
	  ANSI[i+1]=0;
	  if (!(data->Address=GetProcAddress(hDLL,ANSI))) return TYPE_E_DLLFUNCTIONNOTFOUND;
  }

  return S_OK;
}
DWORD SubGetProcAddress(LPWSTR dllFile,LPWSTR procName,COMDATA* data)
{
  HINSTANCE hDLL=LoadLibraryW(dllFile);
  if (hDLL==0) return TYPE_E_CANTLOADLIBRARY;
	
  return SubSubGetProcAddress(hDLL,procName,data);
}

// The main routine
void CallAPI(COMDATA* data)
{
	//This is the main routine of sfcmini.
	//COMDATA contains:
	//  Address that is obtained by LoadLibraries followed by GetProcAddress,
	//  Stack[] that contains the parameters,
	//  and StackNum that is the number of parameters.

   int i,j;
   DWORD Address=(DWORD)data->Address;
   int* Stack=data->Stack;
   int StackNum=data->cArgs;

   //Prepare the stack and call API

  i=StackNum+1;
  j=(int)&Stack[StackNum-1];
  _asm mov ecx,i;    //Number of parameters
  _asm mov ebx,j;    //Address of last parameter
  _asm mov i,esp;    //cdecl support

  _asm jmp label2;   //Begin stack making process
label1:
  _asm push [ebx];
  _asm dec ebx;      // for (ecx=data->StackNum;0<ecx;ecx--) {
  _asm dec ebx;      //   _asm push data->Stack[ecx-1];
  _asm dec ebx;      // }
  _asm dec ebx;
label2:
  _asm loop label1;

  _asm call Address; //call the API here

  _asm mov esp,i;    //cdecl support
  _asm mov i,eax;    //Store the return codes from API
  _asm mov j,edx;

  //Copy the return codes to COMDATA
  data->eax=i;
  data->edx=j;

}

//Method definition
DWORD DynaCall_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
  int i,j;
  for (i=0;i<(int)cNames;i++)
  {
	rgDispId[i] = DISPID_UNKNOWN;
    if      (!lstrcmpiW(rgszNames[i],L"Declare"))         rgDispId[i]=1;
    else if (!lstrcmpiW(rgszNames[i],L"DeclareA"))        rgDispId[i]=1;
    else if (!lstrcmpiW(rgszNames[i],L"DeclareW"))        rgDispId[i]=2;
    else if (!lstrcmpiW(rgszNames[i],L"eax"))             rgDispId[i]=3;
    else if (!lstrcmpiW(rgszNames[i],L"edx"))             rgDispId[i]=4;
    else if (!lstrcmpiW(rgszNames[i],L"Address"))         rgDispId[i]=5;
    else if (!lstrcmpiW(rgszNames[i],L"CallBack"))        rgDispId[i]=6;
    else if (!lstrcmpiW(rgszNames[i],L"LoadLibraries"))   rgDispId[i]=10;
    else if (!lstrcmpiW(rgszNames[i],L"LoadLibrariesA"))  rgDispId[i]=10;
    else if (!lstrcmpiW(rgszNames[i],L"LoadLibrariesW"))  rgDispId[i]=11;
	else if (0<data->hDllNum) {//Find Procedure Address
		data->Address=0;
		for (j=0;j<data->hDllNum;j++)
			if (SubSubGetProcAddress(data->hDlls[j],rgszNames[i],data)==S_OK) break;
		if (data->Address==0) return TYPE_E_DLLFUNCTIONNOTFOUND;
		for (j=0;j<data->ProcNum;j++)
			if (data->Address==data->Procs[j]) break;
		if (j<data->ProcNum) rgDispId[i]=256+j;//If find it in list, return the ID.
		else {                                 //Otherwise, add it to the list.
			void** Procs2=new void*[data->ProcNum+1];
			for (j=0;j<data->ProcNum;j++) Procs2[j]=data->Procs[j];
			delete [] data->Procs;
			data->Procs=Procs2;
			data->Procs[data->ProcNum]=data->Address;
			rgDispId[i]=256+(data->ProcNum++);
		}
	} else return DISP_E_MEMBERNOTFOUND;
  }
  return S_OK;
}

//Method Invoke
DWORD DynaCall_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
  int vInt,i,StrLen;
  LPWSTR Unicode,dllFile,procName;
  int cArgs = pDispParams->cArgs;
  VARIANTARG* rgvarg = pDispParams->rgvarg;
  COMDATA* data2;
  DWORD ret;

  if (wFlags & (DISPATCH_METHOD|DISPATCH_PROPERTYGET) ) 
	  switch (dispIdMember)
  {
  case 1: //DeclareA(dllFile as string, procName as string)
  case 2: //DeclareW(dllFile as string, procName as string)
	  if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
	  if (!ResolveUnicode(&rgvarg[1],&Unicode)) return DISP_E_BADPARAMCOUNT;
	  dllFile=Unicode;
	  if (!ResolveUnicode(&rgvarg[0],&Unicode)) return DISP_E_BADPARAMCOUNT;
	  procName=Unicode;
	  if (dispIdMember==2) data->IsUnicode=TRUE;
	  else data->IsUnicode=FALSE;
	  data->hDllNum=0;
	  data->ProcNum=0;
	  delete [] data->hDlls;
	  delete [] data->Procs;
	  ret=SubGetProcAddress(dllFile,procName,data);
	  if (pVarResult && ret==S_OK) {
		pVarResult->vt=VT_DISPATCH;
		pVarResult->pdispVal=NewComClass(data->COM_ID);
		data2=GetDataFromComClass(pVarResult->pdispVal);
		data2->Copy(data);
	  }
	  return ret;
  case 3: //Function eax() as int32
	  if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
	  if (pVarResult) {
	    pVarResult->lVal=data->eax;
	    pVarResult->vt=VT_I4;                 //32 bit int
	  }
	  return S_OK;
  case 4: //Function edx() as int32
	  if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
	  if (pVarResult) {
	    pVarResult->lVal=data->edx;
	    pVarResult->vt=VT_I4;                 //32 bit int
	  }
	  return S_OK;
  case 5: //Function Address() as int32
	  if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
	  if (pVarResult) {
	    pVarResult->lVal=(int)data->Address;
	    pVarResult->vt=VT_I4;                 //32 bit int
	  }
	  return S_OK;
  case 6: //Function CallBack(procClass as ClassObj, paramNum as int32) as int32
		if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
		if (rgvarg[1].vt==VT_DISPATCH){
			data->pDisp=rgvarg[1].pdispVal;
		} else if (rgvarg[1].vt & VT_BYREF) {
			if (rgvarg[1].pvarVal->vt!=VT_DISPATCH) return DISP_E_BADPARAMCOUNT;
			data->pDisp=rgvarg[1].pvarVal->pdispVal;
		} else return DISP_E_BADPARAMCOUNT;
		if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
		data->CallBackParamNum=vInt;
		LPOLESTR* rgszNames;
		rgszNames=new LPOLESTR;
		DISPID* rgDispId;
		rgDispId=new DISPID;
		rgszNames[0]=L"CallBack";
		i=data->pDisp->GetIDsOfNames(GUID_NULL, rgszNames,1, NULL, rgDispId);
		if (i!=S_OK) return i;
		data->rgDispId=rgDispId[0];
		delete rgszNames;
		delete rgDispId;
		if (pVarResult) {
			#ifdef AMD
			//The global PreCallBack (see above) function will be called as the call back function.
			//dataForCallBack[0]=data;
			pVarResult->lVal=(int)SelectCallBackFunction(data); // Pointer of PreCallBackX global function.
			#endif
			#ifdef INTEL
			//Assemble the Call Back routine here.
			//The global CallBack (see above) function will be called
			//by jmp command in this routine.
			char* CB;
			int *pData, *cbAddr;
			CB=(char*)data->Malloc(15);
			CB[0]=(char)0xb8; // mov       eax,&data
			pData=(int*)&CB[1];
			*pData=(int)data;       // Pointer of COMDATA class
			CB[5]=(char)0x5a; // pop       edx //contains return address
			CB[6]=(char)0x50; // push      eax
			CB[7]=(char)0x52; // push      edx
			CB[8]=(char)0xb8; // mov       eax,*Tools_CallBack
			cbAddr=(int*)&CB[9];
			*cbAddr=(int)*CallBack; // Pointer of CallBack global function.
			CB[13]=(char)0xff;
			CB[14]=(char)0xe0; // jmp       eax
			pVarResult->lVal=(int)CB;
			#endif
			pVarResult->vt=VT_I4;                 //32 bit int
		}
		return S_OK;
  case 10: //Sub LoadLibrariesA(dllFile as string [,dllFile as string [, ... ]]])
  case 11: //Sub LoadLibrariesW(dllFile as string [,dllFile as string [, ... ]]])
	  if (cArgs==0) return DISP_E_BADPARAMCOUNT;
	  delete [] data->hDlls;
	  data->hDlls=new HINSTANCE[cArgs];
	  for (i=cArgs-1;0<=i;i--){
		  if (!ResolveUnicode(&rgvarg[i],&Unicode)) return DISP_E_BADPARAMCOUNT;
		  if ((data->hDlls[i]=LoadLibraryW(Unicode))==0) return TYPE_E_CANTLOADLIBRARY;
	  }
	  data->hDllNum=cArgs;
	  if (dispIdMember==11) data->IsUnicode=TRUE;
	  else data->IsUnicode=FALSE;
	  if (pVarResult) {
		pVarResult->vt=VT_DISPATCH;
		pVarResult->pdispVal=NewComClass(data->COM_ID);
		data2=GetDataFromComClass(pVarResult->pdispVal);
		data2->Copy(data);
	  }
	  return S_OK;
  default: //Call the API 
	  if (dispIdMember==0) {
		  if (data->hDllNum!=0 || data->ProcNum!=0) return DISP_E_BADPARAMCOUNT;
	  } else if (256<=dispIdMember && dispIdMember<256+data->ProcNum) {
		  data->Address=data->Procs[dispIdMember-256];
	  } else return (DWORD)DISPID_UNKNOWN;
	  if (data->Address==0) return DISP_E_BADPARAMCOUNT;
	  data->Stack=new int[cArgs];
	  data->cArgs=cArgs;
	  for (i=cArgs-1;0<=i;i--)
	  {
		if (!ResolveInt(&rgvarg[i],&vInt))
		{
			if (!ResolveUnicode(&rgvarg[i],&Unicode)) return DISP_E_BADPARAMCOUNT;
			if (data->IsUnicode) vInt=(int)Unicode;
			else vInt=(int)CreateAnsiString(Unicode,data,MALLOC_TEMPORARY);
		}
		data->Stack[cArgs-1-i]=vInt;
	  }
	  CallAPI(data);

	  //Resolve Unicode from ANSI string
	  if (!data->IsUnicode) for (i=cArgs-1;0<=i;i--)
	  {
		  if (rgvarg[i].vt & VT_BYREF) 
			  if (rgvarg[i].pvarVal->vt==VT_BSTR)
			  { //get Unicode 
				  StrLen=MultiByteToWideChar(CP_ACP,0,(LPSTR)data->Stack[cArgs-1-i],-1,0,0);
				  MultiByteToWideChar(CP_ACP,0,(LPSTR)data->Stack[cArgs-1-i],-1,rgvarg[i].pvarVal->bstrVal,StrLen);
			  }
	  }
	  if (pVarResult) {
	    pVarResult->lVal=data->eax;
	    pVarResult->vt=VT_I4;                 //32 bit int
	  }
	  delete data->Stack;
	  //"Free memory" code will be here.
	  return S_OK;
  } else if (wFlags & DISPATCH_PROPERTYPUT) {
	  return (DWORD)DISPID_UNKNOWN;
  } else return DISP_E_BADPARAMCOUNT;

}
