/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.msgpack.type.RawTemplate;

public final class Raw {
    private byte[] bytes;
    private String string;

    public Raw(byte[] bytes) {
        this.bytes = bytes;
        this.string = null;
    }

    public Raw(String string) {
        this.bytes = null;
        this.string = string;
    }

    public String toString() {
        if (this.string == null) {
            try {
                this.string = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.string;
    }

    public byte[] toByteArray() {
        if (this.bytes == null) {
            try {
                this.bytes = this.string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytes;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray());
    }

    static {
        RawTemplate.load();
    }
}

