/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import org.msgpack.template.BeansFieldEntryReader;
import org.msgpack.template.builder.AnnotationTemplateBuilderSelector;
import org.msgpack.template.builder.ArrayTemplateBuilderSelector;
import org.msgpack.template.builder.BeansBuildContext;
import org.msgpack.template.builder.BeansTemplateBuilder;
import org.msgpack.template.builder.BeansTemplateBuilderSelector;
import org.msgpack.template.builder.BuildContextBase;
import org.msgpack.template.builder.BuildContextFactory;
import org.msgpack.template.builder.BuilderSelector;
import org.msgpack.template.builder.EnumTemplateBuilderSelector;
import org.msgpack.template.builder.JavassistTemplateBuilder;
import org.msgpack.template.builder.OrdinalEnumTemplateBuilderSelector;
import org.msgpack.template.builder.ReflectionTemplateBuilder;
import org.msgpack.template.builder.TemplateBuilder;

public class BuilderSelectorRegistry {
    private static BuilderSelectorRegistry instance = new BuilderSelectorRegistry();
    TemplateBuilder forceBuilder;
    List<BuilderSelector> builderSelectors = new LinkedList<BuilderSelector>();

    public static BuilderSelectorRegistry getInstance() {
        return instance;
    }

    private BuilderSelectorRegistry() {
    }

    private static void initForJava() {
        instance.append(new ArrayTemplateBuilderSelector());
        if (BuilderSelectorRegistry.isSupportJavassist()) {
            instance.append(new AnnotationTemplateBuilderSelector(new JavassistTemplateBuilder()));
            BuilderSelectorRegistry.instance.forceBuilder = new JavassistTemplateBuilder();
            instance.append(new BeansTemplateBuilderSelector(new JavassistTemplateBuilder(new BeansFieldEntryReader(), new BuildContextFactory(){

                public BuildContextBase createBuildContext(JavassistTemplateBuilder builder) {
                    return new BeansBuildContext(builder);
                }
            })));
        } else {
            instance.append(new AnnotationTemplateBuilderSelector(new ReflectionTemplateBuilder()));
            BuilderSelectorRegistry.instance.forceBuilder = new ReflectionTemplateBuilder();
            instance.append(new BeansTemplateBuilderSelector(new BeansTemplateBuilder()));
        }
        instance.append(new OrdinalEnumTemplateBuilderSelector());
        instance.append(new EnumTemplateBuilderSelector());
    }

    public static boolean isSupportJavassist() {
        try {
            return !System.getProperty("java.vm.name").equals("Dalvik");
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean contains(String builderSelectorName) {
        for (BuilderSelector bs : this.builderSelectors) {
            if (!bs.getName().equals(builderSelectorName)) continue;
            return true;
        }
        return false;
    }

    public void append(BuilderSelector builderSelector) {
        if (this.contains(builderSelector.getName())) {
            throw new RuntimeException("Duplicate BuilderSelector name:" + builderSelector.getName());
        }
        this.builderSelectors.add(builderSelector);
    }

    public void prepend(BuilderSelector builderSelector) {
        if (this.contains(builderSelector.getName())) {
            throw new RuntimeException("Duplicate BuilderSelector name:" + builderSelector.getName());
        }
        if (this.builderSelectors.size() > 0) {
            this.builderSelectors.add(0, builderSelector);
        } else {
            this.builderSelectors.add(builderSelector);
        }
    }

    public void insert(int index, BuilderSelector builderSelector) {
        if (this.contains(builderSelector.getName())) {
            throw new RuntimeException("Duplicate BuilderSelector name:" + builderSelector.getName());
        }
        if (this.builderSelectors.size() > 0) {
            this.builderSelectors.add(index, builderSelector);
        } else {
            this.builderSelectors.add(builderSelector);
        }
    }

    public void replace(BuilderSelector builderSelector) {
        String name = builderSelector.getName();
        int index = this.getIndex(name);
        this.builderSelectors.add(index, builderSelector);
        this.builderSelectors.remove(index + 1);
    }

    public void insertBefore(String builderSelectorName, BuilderSelector builderSelector) {
        int index = this.getIndex(builderSelectorName);
        this.builderSelectors.add(index, builderSelector);
    }

    public void insertAfter(String builderSelectorName, BuilderSelector builderSelector) {
        int index = this.getIndex(builderSelectorName);
        if (index + 1 == this.builderSelectors.size()) {
            this.builderSelectors.add(builderSelector);
        } else {
            this.builderSelectors.add(index + 1, builderSelector);
        }
    }

    private int getIndex(String builderSelectorName) {
        int index = 0;
        for (BuilderSelector bs : this.builderSelectors) {
            if (bs.getName().equals(builderSelectorName)) break;
            ++index;
        }
        if (index >= this.builderSelectors.size()) {
            throw new RuntimeException(String.format("BuilderSelector named %s does not exist", builderSelectorName));
        }
        return index;
    }

    public TemplateBuilder select(Type target) {
        for (BuilderSelector selector : this.builderSelectors) {
            if (!selector.matchType(target)) continue;
            return selector.getTemplateBuilder(target);
        }
        return null;
    }

    public TemplateBuilder getForceBuilder() {
        return this.forceBuilder;
    }

    public void setForceBuilder(TemplateBuilder forceBuilder) {
        this.forceBuilder = forceBuilder;
    }

    static {
        BuilderSelectorRegistry.initForJava();
    }
}

