/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.TemplateBuildException;
import org.msgpack.template.builder.JavassistTemplateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildContextBase<T extends IFieldEntry> {
    private static Logger LOG = LoggerFactory.getLogger(JavassistTemplateBuilder.class);
    protected JavassistTemplateBuilder director;
    protected String tmplName;
    protected CtClass tmplCtClass;
    protected StringBuilder stringBuilder = null;

    protected abstract Template buildTemplate(Class<?> var1, T[] var2, Template[] var3);

    protected abstract void setSuperClass() throws CannotCompileException, NotFoundException;

    protected abstract void buildConstructor() throws CannotCompileException, NotFoundException;

    protected void buildMethodInit() {
    }

    protected abstract String buildPackMethodBody();

    protected abstract String buildUnpackMethodBody();

    protected abstract String buildConvertMethodBody();

    protected abstract Template buildInstance(Class<?> var1) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException;

    protected abstract void writeTemplate(Class<?> var1, T[] var2, Template[] var3, String var4);

    protected abstract Template loadTemplate(Class<?> var1, T[] var2, Template[] var3);

    public BuildContextBase(JavassistTemplateBuilder director) {
        this.director = director;
    }

    protected Template build(String className) {
        try {
            this.reset(className, false);
            this.buildClass();
            this.buildConstructor();
            this.buildMethodInit();
            this.buildPackMethod();
            this.buildUnpackMethod();
            this.buildConvertMethod();
            return this.buildInstance(this.createClass());
        }
        catch (Exception e) {
            String code = this.getBuiltString();
            if (code != null) {
                LOG.error("builder: " + code, (Throwable)e);
                throw new TemplateBuildException("Cannot compile: " + code, e);
            }
            throw new TemplateBuildException(e);
        }
    }

    protected void reset(String className, boolean isWritten) {
        String tmplName = null;
        tmplName = !isWritten ? className + "_$$_Template" + this.director.nextSeqId() : className + "_$$_Template";
        this.tmplCtClass = this.director.makeCtClass(tmplName);
    }

    protected void buildClass() throws CannotCompileException, NotFoundException {
        this.setSuperClass();
        this.tmplCtClass.addInterface(this.director.getCtClass(Template.class.getName()));
    }

    protected void buildPackMethod() throws CannotCompileException, NotFoundException {
        String mbody = this.buildPackMethodBody();
        int mod = 1;
        CtClass returnType = CtClass.voidType;
        String mname = "pack";
        CtClass[] paramTypes = new CtClass[]{this.director.getCtClass(Packer.class.getName()), this.director.getCtClass(Object.class.getName())};
        CtClass[] exceptTypes = new CtClass[]{this.director.getCtClass(IOException.class.getName())};
        CtMethod newCtMethod = CtNewMethod.make((int)mod, (CtClass)returnType, (String)mname, (CtClass[])paramTypes, (CtClass[])exceptTypes, (String)mbody, (CtClass)this.tmplCtClass);
        this.tmplCtClass.addMethod(newCtMethod);
    }

    protected void buildUnpackMethod() throws CannotCompileException, NotFoundException {
        String mbody = this.buildUnpackMethodBody();
        int mod = 1;
        CtClass returnType = this.director.getCtClass(Object.class.getName());
        String mname = "unpack";
        CtClass[] paramTypes = new CtClass[]{this.director.getCtClass(Unpacker.class.getName()), this.director.getCtClass(Object.class.getName())};
        CtClass[] exceptTypes = new CtClass[]{this.director.getCtClass(MessageTypeException.class.getName())};
        CtMethod newCtMethod = CtNewMethod.make((int)mod, (CtClass)returnType, (String)mname, (CtClass[])paramTypes, (CtClass[])exceptTypes, (String)mbody, (CtClass)this.tmplCtClass);
        this.tmplCtClass.addMethod(newCtMethod);
    }

    protected void buildConvertMethod() throws CannotCompileException, NotFoundException {
        String mbody = this.buildConvertMethodBody();
        int mod = 1;
        CtClass returnType = this.director.getCtClass(Object.class.getName());
        String mname = "convert";
        CtClass[] paramTypes = new CtClass[]{this.director.getCtClass(MessagePackObject.class.getName()), this.director.getCtClass(Object.class.getName())};
        CtClass[] exceptTypes = new CtClass[]{this.director.getCtClass(MessageTypeException.class.getName())};
        CtMethod newCtMethod = CtNewMethod.make((int)mod, (CtClass)returnType, (String)mname, (CtClass[])paramTypes, (CtClass[])exceptTypes, (String)mbody, (CtClass)this.tmplCtClass);
        this.tmplCtClass.addMethod(newCtMethod);
    }

    protected Class<?> createClass() throws CannotCompileException {
        return this.tmplCtClass.toClass(null, null);
    }

    protected void saveClass(String directoryName) throws CannotCompileException, IOException {
        this.tmplCtClass.writeFile(directoryName);
    }

    protected void resetStringBuilder() {
        this.stringBuilder = new StringBuilder();
    }

    protected void buildString(String str) {
        this.stringBuilder.append(str);
    }

    protected void buildString(String format, Object ... args) {
        this.stringBuilder.append(String.format(format, args));
    }

    protected String getBuiltString() {
        if (this.stringBuilder == null) {
            return null;
        }
        return this.stringBuilder.toString();
    }

    protected String primitivePackName(Class<?> type) {
        if (type == Boolean.TYPE) {
            return "packBoolean";
        }
        if (type == Byte.TYPE) {
            return "packByte";
        }
        if (type == Short.TYPE) {
            return "packShort";
        }
        if (type == Integer.TYPE) {
            return "packInt";
        }
        if (type == Long.TYPE) {
            return "packLong";
        }
        if (type == Float.TYPE) {
            return "packFloat";
        }
        if (type == Double.TYPE) {
            return "packDouble";
        }
        return null;
    }

    protected String primitiveUnpackName(Class<?> type) {
        if (type == Boolean.TYPE) {
            return "unpackBoolean";
        }
        if (type == Byte.TYPE) {
            return "unpackByte";
        }
        if (type == Short.TYPE) {
            return "unpackShort";
        }
        if (type == Integer.TYPE) {
            return "unpackInt";
        }
        if (type == Long.TYPE) {
            return "unpackLong";
        }
        if (type == Float.TYPE) {
            return "unpackFloat";
        }
        if (type == Double.TYPE) {
            return "unpackDouble";
        }
        return null;
    }

    protected String primitiveConvertName(Class<?> type) {
        if (type == Boolean.TYPE) {
            return "asBoolean";
        }
        if (type == Byte.TYPE) {
            return "asByte";
        }
        if (type == Short.TYPE) {
            return "asShort";
        }
        if (type == Integer.TYPE) {
            return "asInt";
        }
        if (type == Long.TYPE) {
            return "asLong";
        }
        if (type == Float.TYPE) {
            return "asFloat";
        }
        if (type == Double.TYPE) {
            return "asDouble";
        }
        return null;
    }

    protected void write(String className, String directoryName) {
        try {
            this.reset(className, true);
            this.buildClass();
            this.buildConstructor();
            this.buildMethodInit();
            this.buildPackMethod();
            this.buildUnpackMethod();
            this.buildConvertMethod();
            this.saveClass(directoryName);
        }
        catch (Exception e) {
            String code = this.getBuiltString();
            if (code != null) {
                LOG.error("builder: " + code, (Throwable)e);
                throw new TemplateBuildException("Cannot compile: " + code, e);
            }
            throw new TemplateBuildException(e);
        }
    }

    protected Template load(String className) {
        String tmplName = className + "_$$_Template";
        try {
            Class<?> tmplClass = this.getClass().getClassLoader().loadClass(tmplName);
            return this.buildInstance(tmplClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            String code = this.getBuiltString();
            if (code != null) {
                LOG.error("builder: " + code, (Throwable)e);
                throw new TemplateBuildException("Cannot compile: " + code, e);
            }
            throw new TemplateBuildException(e);
        }
    }
}

