/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Template;
import org.msgpack.template.FieldEntry;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.builder.BuildContextBase;
import org.msgpack.template.builder.JavassistTemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContext
extends BuildContextBase<FieldEntry> {
    protected IFieldEntry[] entries;
    protected Class<?> origClass;
    protected String origName;
    protected Template[] templates;
    protected int minimumArrayLength;

    public BuildContext(JavassistTemplateBuilder director) {
        super(director);
    }

    public Template buildTemplate(Class<?> targetClass, FieldEntry[] entries, Template[] templates) {
        this.entries = entries;
        this.templates = templates;
        this.origClass = targetClass;
        this.origName = this.origClass.getName();
        return this.build(this.origName);
    }

    @Override
    protected void setSuperClass() throws CannotCompileException, NotFoundException {
        this.tmplCtClass.setSuperclass(this.director.getCtClass(JavassistTemplateBuilder.JavassistTemplate.class.getName()));
    }

    @Override
    protected void buildConstructor() throws CannotCompileException, NotFoundException {
        CtConstructor newCtCons = CtNewConstructor.make((CtClass[])new CtClass[]{this.director.getCtClass(Class.class.getName()), this.director.getCtClass(Template.class.getName() + "[]")}, (CtClass[])new CtClass[0], (CtClass)this.tmplCtClass);
        this.tmplCtClass.addConstructor(newCtCons);
    }

    @Override
    protected Template buildInstance(Class<?> c) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> cons = c.getConstructor(Class.class, Template[].class);
        Object tmpl = cons.newInstance(this.origClass, this.templates);
        return (Template)tmpl;
    }

    @Override
    protected void buildMethodInit() {
        this.minimumArrayLength = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            IFieldEntry e = this.entries[i];
            if (!e.isRequired() && !e.isNullable()) continue;
            this.minimumArrayLength = i + 1;
        }
    }

    @Override
    protected String buildPackMethodBody() {
        this.resetStringBuilder();
        this.buildString("{");
        this.buildString("%s _$$_t = (%s)$2;", this.origName, this.origName);
        this.buildString("$1.packArray(%d);", this.entries.length);
        for (int i = 0; i < this.entries.length; ++i) {
            IFieldEntry e = this.entries[i];
            if (!e.isAvailable()) {
                this.buildString("$1.packNil();");
                continue;
            }
            Class<?> type = e.getType();
            if (type.isPrimitive()) {
                this.buildString("$1.%s(_$$_t.%s);", this.primitivePackName(type), e.getName());
                continue;
            }
            this.buildString("if(_$$_t.%s == null) {", e.getName());
            if (!e.isNullable() && !e.isOptional()) {
                this.buildString("throw new %s();", MessageTypeException.class.getName());
            } else {
                this.buildString("$1.packNil();");
            }
            this.buildString("} else {");
            this.buildString("  this.templates[%d].pack($1, _$$_t.%s);", i, e.getName());
            this.buildString("}");
        }
        this.buildString("}");
        return this.getBuiltString();
    }

    @Override
    protected String buildUnpackMethodBody() {
        Class<?> type;
        IFieldEntry e;
        int i;
        this.resetStringBuilder();
        this.buildString("{ ");
        this.buildString("%s _$$_t;", this.origName);
        this.buildString("if($2 == null) {");
        this.buildString("  _$$_t = new %s();", this.origName);
        this.buildString("} else {");
        this.buildString("  _$$_t = (%s)$2;", this.origName);
        this.buildString("}");
        this.buildString("int length = $1.unpackArray();");
        this.buildString("if(length < %d) {", this.minimumArrayLength);
        this.buildString("  throw new %s();", MessageTypeException.class.getName());
        this.buildString("}");
        for (i = 0; i < this.minimumArrayLength; ++i) {
            e = this.entries[i];
            if (!e.isAvailable()) {
                this.buildString("$1.unpackObject();");
                continue;
            }
            this.buildString("if($1.tryUnpackNull()) {");
            if (e.isRequired()) {
                this.buildString("throw new %s();", MessageTypeException.class.getName());
            } else if (!e.isOptional()) {
                this.buildString("_$$_t.%s = null;", e.getName());
            }
            this.buildString("} else {");
            type = e.getType();
            if (type.isPrimitive()) {
                this.buildString("_$$_t.%s = $1.%s();", e.getName(), this.primitiveUnpackName(type));
            } else {
                this.buildString("_$$_t.%s = (%s)this.templates[%d].unpack($1, _$$_t.%s);", e.getName(), e.getJavaTypeName(), i, e.getName());
            }
            this.buildString("}");
        }
        while (i < this.entries.length) {
            this.buildString("if(length <= %d) { return _$$_t; }", i);
            e = this.entries[i];
            if (!e.isAvailable()) {
                this.buildString("$1.unpackObject();");
            } else {
                this.buildString("if($1.tryUnpackNull()) {");
                this.buildString("} else {");
                type = e.getType();
                if (type.isPrimitive()) {
                    this.buildString("_$$_t.%s = $1.%s();", e.getName(), this.primitiveUnpackName(type));
                } else {
                    this.buildString("_$$_t.%s = (%s)this.templates[%d].unpack($1, _$$_t.%s);", e.getName(), e.getJavaTypeName(), i, e.getName());
                }
                this.buildString("}");
            }
            ++i;
        }
        this.buildString("for(int i=%d; i < length; i++) {", i);
        this.buildString("  $1.unpackObject();");
        this.buildString("}");
        this.buildString("return _$$_t;");
        this.buildString("}");
        return this.getBuiltString();
    }

    @Override
    protected String buildConvertMethodBody() {
        Class<?> type;
        IFieldEntry e;
        int i;
        this.resetStringBuilder();
        this.buildString("{ ");
        this.buildString("%s _$$_t;", this.origName);
        this.buildString("if($2 == null) {");
        this.buildString("  _$$_t = new %s();", this.origName);
        this.buildString("} else {");
        this.buildString("  _$$_t = (%s)$2;", this.origName);
        this.buildString("}");
        this.buildString("%s[] array = $1.asArray();", MessagePackObject.class.getName());
        this.buildString("int length = array.length;");
        this.buildString("if(length < %d) {", this.minimumArrayLength);
        this.buildString("  throw new %s();", MessageTypeException.class.getName());
        this.buildString("}");
        this.buildString("%s obj;", MessagePackObject.class.getName());
        for (i = 0; i < this.minimumArrayLength; ++i) {
            e = this.entries[i];
            if (!e.isAvailable()) continue;
            this.buildString("obj = array[%d];", i);
            this.buildString("if(obj.isNil()) {");
            if (e.isRequired()) {
                this.buildString("throw new %s();", MessageTypeException.class.getName());
            } else if (!e.isOptional()) {
                this.buildString("_$$_t.%s = null;", e.getName());
            }
            this.buildString("} else {");
            type = e.getType();
            if (type.isPrimitive()) {
                this.buildString("_$$_t.%s = obj.%s();", e.getName(), this.primitiveConvertName(type));
            } else {
                this.buildString("_$$_t.%s = (%s)this.templates[%d].convert(obj, _$$_t.%s);", e.getName(), e.getJavaTypeName(), i, e.getName());
            }
            this.buildString("}");
        }
        while (i < this.entries.length) {
            this.buildString("if(length <= %d) { return _$$_t; }", i);
            e = this.entries[i];
            if (e.isAvailable()) {
                this.buildString("obj = array[%d];", i);
                this.buildString("if(obj.isNil()) {");
                this.buildString("} else {");
                type = e.getType();
                if (type.isPrimitive()) {
                    this.buildString("_$$_t.%s = obj.%s();", e.getName(), this.primitiveConvertName(type));
                } else {
                    this.buildString("_$$_t.%s = (%s)this.templates[%d].convert(obj, _$$_t.%s);", e.getName(), e.getJavaTypeName(), i, e.getName());
                }
                this.buildString("}");
            }
            ++i;
        }
        this.buildString("return _$$_t;");
        this.buildString("}");
        return this.getBuiltString();
    }

    public void writeTemplate(Class<?> targetClass, FieldEntry[] entries, Template[] templates, String directoryName) {
        this.entries = entries;
        this.templates = templates;
        this.origClass = targetClass;
        this.origName = this.origClass.getName();
        this.write(this.origName, directoryName);
    }

    public Template loadTemplate(Class<?> targetClass, FieldEntry[] entries, Template[] templates) {
        this.entries = entries;
        this.templates = templates;
        this.origClass = targetClass;
        this.origName = this.origClass.getName();
        return this.load(this.origName);
    }
}

