/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.msgpack.AbstractTemplate;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.BooleanArrayTemplate;
import org.msgpack.template.DoubleArrayTemplate;
import org.msgpack.template.FloatArrayTemplate;
import org.msgpack.template.IntArrayTemplate;
import org.msgpack.template.LongArrayTemplate;
import org.msgpack.template.ShortArrayTemplate;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.TemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTemplateBuilder
implements TemplateBuilder {
    @Override
    public Template buildTemplate(Type arrayType) {
        Class baseClass;
        Type baseType;
        int dim = 1;
        if (arrayType instanceof GenericArrayType) {
            GenericArrayType type = (GenericArrayType)arrayType;
            baseType = type.getGenericComponentType();
            while (baseType instanceof GenericArrayType) {
                baseType = ((GenericArrayType)baseType).getGenericComponentType();
                ++dim;
            }
            baseClass = baseType instanceof ParameterizedType ? (Class)((ParameterizedType)baseType).getRawType() : baseType;
        } else {
            Class type = (Class)arrayType;
            baseClass = type.getComponentType();
            while (baseClass.isArray()) {
                baseClass = baseClass.getComponentType();
                ++dim;
            }
            baseType = baseClass;
        }
        return this.toTemplate(arrayType, baseType, baseClass, dim);
    }

    private Template toTemplate(Type arrayType, Type genericBaseType, Class<?> baseClass, int dim) {
        if (dim == 1) {
            if (baseClass == Boolean.TYPE) {
                return BooleanArrayTemplate.getInstance();
            }
            if (baseClass == Short.TYPE) {
                return ShortArrayTemplate.getInstance();
            }
            if (baseClass == Integer.TYPE) {
                return IntArrayTemplate.getInstance();
            }
            if (baseClass == Long.TYPE) {
                return LongArrayTemplate.getInstance();
            }
            if (baseClass == Float.TYPE) {
                return FloatArrayTemplate.getInstance();
            }
            if (baseClass == Double.TYPE) {
                return DoubleArrayTemplate.getInstance();
            }
            Template baseTemplate = TemplateRegistry.lookup(genericBaseType);
            return new ReflectionObjectArrayTemplate(baseClass, baseTemplate);
        }
        if (dim == 2) {
            Class<?> componentClass = Array.newInstance(baseClass, 0).getClass();
            Template componentTemplate = this.toTemplate(arrayType, genericBaseType, baseClass, dim - 1);
            return new ReflectionMultidimentionalArrayTemplate(componentClass, componentTemplate);
        }
        ReflectionMultidimentionalArrayTemplate componentTemplate = (ReflectionMultidimentionalArrayTemplate)this.toTemplate(arrayType, genericBaseType, baseClass, dim - 1);
        Class<?> componentClass = Array.newInstance(componentTemplate.getComponentClass(), 0).getClass();
        return new ReflectionMultidimentionalArrayTemplate(componentClass, componentTemplate);
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        throw new UnsupportedOperationException(targetType.toString());
    }

    @Override
    public Template loadTemplate(Type targetType) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionMultidimentionalArrayTemplate
    extends AbstractTemplate {
        private Class<?> componentClass;
        private Template componentTemplate;

        public ReflectionMultidimentionalArrayTemplate(Class<?> componentClass, Template componentTemplate) {
            this.componentClass = componentClass;
            this.componentTemplate = componentTemplate;
        }

        Class<?> getComponentClass() {
            return this.componentClass;
        }

        @Override
        public void pack(Packer pk, Object target) throws IOException {
            Object[] array = (Object[])target;
            int length = array.length;
            pk.packArray(length);
            for (int i = 0; i < length; ++i) {
                this.componentTemplate.pack(pk, array[i]);
            }
        }

        @Override
        public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
            int length = pac.unpackArray();
            Object[] array = (Object[])Array.newInstance(this.componentClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = this.componentTemplate.unpack(pac, null);
            }
            return array;
        }

        @Override
        public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
            MessagePackObject[] src = from.asArray();
            int length = src.length;
            Object[] array = (Object[])Array.newInstance(this.componentClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = this.componentTemplate.convert(src[i], null);
            }
            return array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionObjectArrayTemplate
    extends AbstractTemplate {
        private Class<?> componentClass;
        private Template elementTemplate;

        public ReflectionObjectArrayTemplate(Class<?> componentClass, Template elementTemplate) {
            this.componentClass = componentClass;
            this.elementTemplate = elementTemplate;
        }

        @Override
        public void pack(Packer pk, Object target) throws IOException {
            if (!(target instanceof Object[]) || !this.componentClass.isAssignableFrom(target.getClass().getComponentType())) {
                throw new MessageTypeException();
            }
            Object[] array = (Object[])target;
            int length = array.length;
            pk.packArray(length);
            for (int i = 0; i < length; ++i) {
                this.elementTemplate.pack(pk, array[i]);
            }
        }

        @Override
        public Object unpack(Unpacker pac, Object to) throws IOException {
            int length = pac.unpackArray();
            Object[] array = (Object[])Array.newInstance(this.componentClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = this.elementTemplate.unpack(pac, null);
            }
            return array;
        }

        @Override
        public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
            MessagePackObject[] src = from.asArray();
            int length = src.length;
            Object[] array = (Object[])Array.newInstance(this.componentClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = this.elementTemplate.convert(src[i], null);
            }
            return array;
        }
    }
}

