/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class ShortTemplate
implements Template {
    static final ShortTemplate instance = new ShortTemplate();

    private ShortTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packShort((Short)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackShort();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asShort();
    }

    public static ShortTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Short.class, instance);
        TemplateRegistry.register(Short.TYPE, instance);
    }
}

