/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.GenericTemplate1;
import org.msgpack.template.TemplateRegistry;

public class ListTemplate
implements Template {
    private Template elementTemplate;

    static void load() {
    }

    public ListTemplate(Template elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    public Template getElementTemplate() {
        return this.elementTemplate;
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof List)) {
            if (target == null) {
                throw new MessageTypeException(new NullPointerException("target is null."));
            }
            throw new MessageTypeException("target is not List type: " + target.getClass());
        }
        List list = (List)target;
        pk.packArray(list.size());
        for (Object element : list) {
            this.elementTemplate.pack(pk, element);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        ArrayList<Object> list;
        int length = pac.unpackArray();
        if (to == null) {
            list = new ArrayList<Object>(length);
        } else {
            list = (ArrayList<Object>)to;
            list.clear();
        }
        while (length > 0) {
            list.add(this.elementTemplate.unpack(pac, null));
            --length;
        }
        return list;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        ArrayList<Object> list;
        MessagePackObject[] array = from.asArray();
        if (to == null) {
            list = new ArrayList<Object>(array.length);
        } else {
            list = (ArrayList<Object>)to;
            list.clear();
        }
        for (MessagePackObject element : array) {
            list.add(this.elementTemplate.convert(element, null));
        }
        return list;
    }

    static {
        TemplateRegistry.registerGeneric(List.class, new GenericTemplate1(ListTemplate.class));
        TemplateRegistry.register(List.class, new ListTemplate(AnyTemplate.getInstance()));
    }
}

