/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.math.BigDecimal;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class BigDecimalTemplate
implements Template {
    static final BigDecimalTemplate instance = new BigDecimalTemplate();

    public void pack(Packer pk, Object target) throws IOException {
        BigDecimal temp = (BigDecimal)target;
        try {
            pk.packString(temp.toString());
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        String temp = pac.unpackString();
        return new BigDecimal(temp);
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        String temp = from.asString();
        return new BigDecimal(temp);
    }

    public static BigDecimalTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(BigDecimal.class, instance);
    }
}

