/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.msgpack.MessageTypeException;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansFieldEntry
implements IFieldEntry {
    PropertyDescriptor desc;
    FieldOption option = FieldOption.DEFAULT;

    public BeansFieldEntry(PropertyDescriptor desc) {
        this.desc = desc;
    }

    @Override
    public String getName() {
        return this.desc.getDisplayName();
    }

    public String getGetterName() {
        return this.desc.getReadMethod().getName();
    }

    public String getSetterName() {
        return this.desc.getWriteMethod().getName();
    }

    @Override
    public Class<?> getType() {
        return this.desc.getPropertyType();
    }

    @Override
    public String getJavaTypeName() {
        Class<?> type = this.getType();
        if (type.isArray()) {
            return BeansFieldEntry.arrayTypeToString(type);
        }
        return type.getName();
    }

    static String arrayTypeToString(Class<?> type) {
        int dim = 1;
        Class<?> baseType = type.getComponentType();
        while (baseType.isArray()) {
            baseType = baseType.getComponentType();
            ++dim;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(baseType.getName());
        for (int i = 0; i < dim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public Type getGenericType() {
        return this.desc.getReadMethod().getGenericReturnType();
    }

    @Override
    public FieldOption getOption() {
        return this.option;
    }

    public void setOption(FieldOption option) {
        this.option = option;
    }

    @Override
    public boolean isAvailable() {
        return this.option != FieldOption.IGNORE;
    }

    @Override
    public boolean isRequired() {
        return this.option == FieldOption.REQUIRED;
    }

    @Override
    public boolean isOptional() {
        return this.option == FieldOption.OPTIONAL;
    }

    @Override
    public boolean isNullable() {
        return this.option == FieldOption.NULLABLE;
    }

    public Object get(Object target) {
        try {
            return this.desc.getReadMethod().invoke(target, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MessageTypeException(e);
        }
        catch (IllegalAccessException e) {
            throw new MessageTypeException(e);
        }
        catch (InvocationTargetException e) {
            throw new MessageTypeException(e);
        }
    }

    public void set(Object target, Object value) {
        try {
            this.desc.getWriteMethod().invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new MessageTypeException(e);
        }
        catch (IllegalAccessException e) {
            throw new MessageTypeException(e);
        }
        catch (InvocationTargetException e) {
            throw new MessageTypeException(e);
        }
    }
}

