/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.object.IntegerType;
import org.msgpack.object.LongIntegerTypeIMPL;
import org.msgpack.object.ShortIntegerTypeIMPL;

class BigIntegerTypeIMPL
extends IntegerType {
    private BigInteger value;

    BigIntegerTypeIMPL(BigInteger value) {
        this.value = value;
    }

    public byte asByte() {
        if (this.value.compareTo(BigInteger.valueOf(127L)) > 0) {
            throw new MessageTypeException("type error");
        }
        return this.value.byteValue();
    }

    public short asShort() {
        if (this.value.compareTo(BigInteger.valueOf(32767L)) > 0) {
            throw new MessageTypeException("type error");
        }
        return this.value.shortValue();
    }

    public int asInt() {
        if (this.value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new MessageTypeException("type error");
        }
        return this.value.intValue();
    }

    public long asLong() {
        if (this.value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new MessageTypeException("type error");
        }
        return this.value.longValue();
    }

    public BigInteger asBigInteger() {
        return this.value;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public void messagePack(Packer pk) throws IOException {
        pk.packBigInteger(this.value);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            if (obj.getClass() == ShortIntegerTypeIMPL.class) {
                return BigInteger.valueOf(((ShortIntegerTypeIMPL)obj).longValue()).equals(this.value);
            }
            if (obj.getClass() == LongIntegerTypeIMPL.class) {
                return BigInteger.valueOf(((LongIntegerTypeIMPL)obj).longValue()).equals(this.value);
            }
            return false;
        }
        return ((BigIntegerTypeIMPL)obj).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object clone() {
        return new BigIntegerTypeIMPL(this.value);
    }
}

