/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.List;

public class VectoredByteBuffer
implements GatheringByteChannel,
ScatteringByteChannel {
    private List<ByteBuffer> vec = new ArrayList<ByteBuffer>();
    private ByteBuffer internalBuffer;
    private ByteBuffer lastInternalBuffer;
    private int chunkSize;
    private int referenceThreshold;

    public VectoredByteBuffer() {
        this(32768);
    }

    public VectoredByteBuffer(int chunkSize) {
        this(chunkSize, 32);
    }

    public VectoredByteBuffer(int chunkSize, int referenceThreshold) {
        this.chunkSize = chunkSize;
        this.referenceThreshold = referenceThreshold;
        this.internalBuffer = ByteBuffer.allocateDirect(chunkSize);
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize(int chunkSize) {
        return this.chunkSize;
    }

    public void setReferenceThreshold(int referenceThreshold) {
        this.referenceThreshold = referenceThreshold;
    }

    public int getReferenceThreshold(int referenceThreshold) {
        return this.referenceThreshold;
    }

    public void close() {
        this.reset();
    }

    public boolean isOpen() {
        return true;
    }

    public synchronized void reset() {
        this.vec.clear();
        this.lastInternalBuffer = null;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || b.length < off + len) {
            throw new IndexOutOfBoundsException();
        }
        if (this.referenceThreshold >= 0 && len > this.referenceThreshold) {
            this.writeReference(b, off, len);
        } else {
            this.writeCopy(b, off, len);
        }
    }

    public void write(int b) {
        byte[] ba = new byte[]{(byte)b};
        this.write(ba);
    }

    public int write(ByteBuffer src) {
        int slen = src.remaining();
        if (this.referenceThreshold >= 0 && slen > this.referenceThreshold) {
            this.writeCopy(src);
        } else {
            this.writeReference(src);
        }
        return slen;
    }

    public synchronized long write(ByteBuffer[] srcs) {
        return this.write(srcs, 0, srcs.length);
    }

    public synchronized long write(ByteBuffer[] srcs, int offset, int length) {
        if (offset < 0 || length < 0 || srcs.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        long total = 0L;
        int i = offset;
        while (offset < length) {
            ByteBuffer src = srcs[i];
            total += (long)this.write(src);
            ++offset;
        }
        return total;
    }

    private synchronized void writeCopy(byte[] b, int off, int len) {
        int ipos = this.internalBuffer.position();
        if (this.internalBuffer.capacity() - ipos < len) {
            int nsize = this.chunkSize > len ? this.chunkSize : len;
            this.internalBuffer = ByteBuffer.allocateDirect(nsize);
            ipos = 0;
        } else if (this.internalBuffer == this.lastInternalBuffer) {
            ByteBuffer dup = this.vec.get(this.vec.size() - 1);
            this.internalBuffer.put(b, off, len);
            dup.limit(ipos + len);
            return;
        }
        this.internalBuffer.put(b, off, len);
        ByteBuffer dup = this.internalBuffer.duplicate();
        dup.position(ipos);
        dup.mark();
        dup.limit(ipos + len);
        this.vec.add(dup);
        this.lastInternalBuffer = this.internalBuffer;
    }

    private synchronized void writeCopy(ByteBuffer src) {
        int slen = src.remaining();
        int ipos = this.internalBuffer.position();
        if (this.internalBuffer.capacity() - ipos < slen) {
            int nsize = this.chunkSize > slen ? this.chunkSize : slen;
            this.internalBuffer = ByteBuffer.allocateDirect(nsize);
            ipos = 0;
        } else if (this.internalBuffer == this.lastInternalBuffer) {
            ByteBuffer dup = this.vec.get(this.vec.size() - 1);
            int dpos = dup.position();
            this.internalBuffer.put(src);
            ByteBuffer dup2 = this.internalBuffer.duplicate();
            dup2.position(dpos);
            dup2.limit(ipos + slen);
            this.vec.set(this.vec.size() - 1, dup2);
            return;
        }
        this.internalBuffer.put(src);
        ByteBuffer dup = this.internalBuffer.duplicate();
        dup.position(ipos);
        dup.mark();
        dup.limit(ipos + slen);
        this.vec.add(dup);
        this.lastInternalBuffer = this.internalBuffer;
    }

    private synchronized void writeReference(byte[] b, int off, int len) {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        this.vec.add(buf);
        this.lastInternalBuffer = null;
    }

    private synchronized void writeReference(ByteBuffer src) {
        ByteBuffer buf = src.duplicate();
        this.vec.add(buf);
        this.lastInternalBuffer = null;
    }

    public synchronized void writeTo(java.io.OutputStream out) throws IOException {
        byte[] tmpbuf = null;
        for (int i = 0; i < this.vec.size(); ++i) {
            ByteBuffer r = this.vec.get(i);
            int rpos = r.position();
            int rlen = r.limit() - rpos;
            if (r.hasArray()) {
                byte[] array = r.array();
                out.write(array, rpos, rlen);
                continue;
            }
            if (tmpbuf == null) {
                int max = rlen;
                for (int j = i + 1; j < this.vec.size(); ++j) {
                    ByteBuffer c = this.vec.get(j);
                    int clen = c.remaining();
                    if (max >= clen) continue;
                    max = clen;
                }
                tmpbuf = new byte[max];
            }
            r.get(tmpbuf, 0, rlen);
            r.position(rpos);
            out.write(tmpbuf, 0, rlen);
        }
    }

    public synchronized byte[] toByteArray() {
        byte[] out = new byte[this.available()];
        int off = 0;
        for (ByteBuffer r : this.vec) {
            int rpos = r.position();
            int rlen = r.limit() - rpos;
            r.get(out, off, rlen);
            r.position(rpos);
            off += rlen;
        }
        return out;
    }

    public synchronized int available() {
        int total = 0;
        for (ByteBuffer r : this.vec) {
            total += r.remaining();
        }
        return total;
    }

    public synchronized int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || b.length < off + len) {
            throw new IndexOutOfBoundsException();
        }
        int start = len;
        while (!this.vec.isEmpty()) {
            ByteBuffer r = this.vec.get(0);
            int rlen = r.remaining();
            if (rlen <= len) {
                r.get(b, off, rlen);
                this.vec.remove(0);
                off += rlen;
                len -= rlen;
                continue;
            }
            r.get(b, off, len);
            return start;
        }
        return start - len;
    }

    public synchronized int read() {
        byte[] ba = new byte[1];
        if (this.read(ba) >= 1) {
            return ba[0];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(ByteBuffer dst) {
        int len;
        int start = len = dst.remaining();
        while (!this.vec.isEmpty()) {
            ByteBuffer r = this.vec.get(0);
            int rlen = r.remaining();
            if (rlen <= len) {
                dst.put(r);
                this.vec.remove(0);
                len -= rlen;
                continue;
            }
            int blim = r.limit();
            r.limit(len);
            try {
                dst.put(r);
            }
            finally {
                r.limit(blim);
            }
            return start;
        }
        return start - len;
    }

    public synchronized long read(ByteBuffer[] dsts) {
        return this.read(dsts, 0, dsts.length);
    }

    public synchronized long read(ByteBuffer[] dsts, int offset, int length) {
        if (offset < 0 || length < 0 || dsts.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        long total = 0L;
        for (int i = offset; i < length; ++i) {
            ByteBuffer dst = dsts[i];
            int dlen = dst.remaining();
            int rlen = this.read(dsts[i]);
            total += (long)rlen;
            if (rlen >= dlen) continue;
            return total;
        }
        return total;
    }

    public synchronized long read(GatheringByteChannel to) throws IOException {
        ByteBuffer r;
        long total = to.write(this.vec.toArray(new ByteBuffer[0]));
        while (!this.vec.isEmpty() && (r = this.vec.get(0)).remaining() == 0) {
            this.vec.remove(0);
        }
        return total;
    }

    public synchronized long skip(long len) {
        if (len <= 0L) {
            return 0L;
        }
        long start = len;
        while (!this.vec.isEmpty()) {
            ByteBuffer r = this.vec.get(0);
            int rlen = r.remaining();
            if ((long)rlen <= len) {
                r.position(r.position() + rlen);
                this.vec.remove(0);
                len -= (long)rlen;
                continue;
            }
            r.position((int)((long)r.position() + len));
            return start;
        }
        return start - len;
    }

    public OutputStream outputStream() {
        return new OutputStream(this);
    }

    public InputStream inputStream() {
        return new InputStream(this);
    }

    public static final class InputStream
    extends java.io.InputStream {
        private VectoredByteBuffer vbb;

        InputStream(VectoredByteBuffer vbb) {
            this.vbb = vbb;
        }

        public int available() {
            return this.vbb.available();
        }

        public int read(byte[] b) {
            return this.vbb.read(b);
        }

        public int read(byte[] b, int off, int len) {
            return this.vbb.read(b, off, len);
        }

        public int read() {
            return this.vbb.read();
        }

        public int read(ByteBuffer dst) {
            return this.vbb.read(dst);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) {
            return this.vbb.read(dsts, offset, length);
        }

        public long read(GatheringByteChannel to) throws IOException {
            return this.vbb.read(to);
        }

        public long skip(long len) {
            return this.vbb.skip(len);
        }
    }

    public static final class OutputStream
    extends java.io.OutputStream {
        private VectoredByteBuffer vbb;

        OutputStream(VectoredByteBuffer vbb) {
            this.vbb = vbb;
        }

        public void write(byte[] b) {
            this.vbb.write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.vbb.write(b, off, len);
        }

        public void write(int b) {
            this.vbb.write(b);
        }

        public int write(ByteBuffer src) {
            return this.vbb.write(src);
        }

        public long write(ByteBuffer[] srcs) {
            return this.vbb.write(srcs);
        }

        public long write(ByteBuffer[] srcs, int offset, int length) {
            return this.vbb.write(srcs, offset, length);
        }

        public void writeTo(OutputStream out) throws IOException {
            this.vbb.writeTo(out);
        }

        public byte[] toByteArray() {
            return this.vbb.toByteArray();
        }
    }
}

