/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import setsuna.core.util.EasyQueryCompiler;
import setsuna.core.util.SetsunaStaticConfig;
import setsuna.core.util.SystemUtil;

public class ConditionContainer {
    protected String[] queryList = null;
    protected Connection conn = null;
    protected PreparedStatement[] preparedStatementList = null;
    protected boolean replaceQueryParamFlg = false;

    public ConditionContainer(String query) throws Exception {
        this.queryList = new String[1];
        this.queryList[0] = query;
    }

    public ConditionContainer(String[] queryList) throws Exception {
        this.queryList = queryList;
    }

    public void buildStreamDatabaseStatement(Connection conn) throws Exception {
        this.conn = conn;
        this.preparedStatementList = new PreparedStatement[this.queryList.length];
        for (int idx = 0; idx < this.queryList.length; ++idx) {
            Pattern p = Pattern.compile("%.*%");
            Matcher m = p.matcher(this.queryList[idx]);
            if (m.find()) {
                this.replaceQueryParamFlg = true;
                continue;
            }
            this.preparedStatementList[idx] = this.conn.prepareStatement(this.queryList[idx]);
        }
    }

    public boolean checkConditionMatchRecode(Map adapterData) throws Exception {
        boolean ret = true;
        for (int idx = 0; idx < this.preparedStatementList.length && ret; ++idx) {
            ResultSet resultSet = null;
            PreparedStatement pst = null;
            if (this.replaceQueryParamFlg) {
                String cnvSql = this.adapterDataMargeQuery(this.queryList[idx], adapterData);
                SystemUtil.debug("-query SQL=[" + cnvSql + "]");
                pst = this.conn.prepareStatement(cnvSql);
                resultSet = pst.executeQuery();
                long end = System.nanoTime();
            } else {
                SystemUtil.debug("-query SQL=[" + this.queryList[idx] + "]");
                resultSet = this.preparedStatementList[idx].executeQuery();
            }
            if (SetsunaStaticConfig.DEFAULT_PIPEINPUT_QUERY_TYPE == 1) {
                if (!resultSet.next()) {
                    ret = false;
                }
            } else if (SetsunaStaticConfig.DEFAULT_PIPEINPUT_QUERY_TYPE == 2) {
                if (!resultSet.next()) {
                    ret = false;
                } else {
                    int count = resultSet.getInt(1);
                    if (count < 1) {
                        return false;
                    }
                }
            }
            resultSet.close();
            if (!this.replaceQueryParamFlg) continue;
            pst.close();
        }
        return ret;
    }

    public void clear() {
        block4: {
            try {
                for (int idx = 0; idx < this.preparedStatementList.length; ++idx) {
                    this.preparedStatementList[idx].close();
                }
                if (this.conn == null) break block4;
                this.conn.close();
            }
            catch (Exception e) {
                this.conn = null;
                for (int idx = 0; idx < this.preparedStatementList.length; ++idx) {
                    this.preparedStatementList[idx] = null;
                }
            }
        }
    }

    private String adapterDataMargeQuery(String targetSql, Map adapterData) {
        String retSql = targetSql;
        for (Map.Entry entry : adapterData.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            retSql = Pattern.compile("%" + key + "%", 2).matcher(retSql).replaceAll("'" + value + "'");
        }
        return retSql;
    }

    public static String[] parseEsayQuery(String queryString) throws Exception {
        return EasyQueryCompiler.compileFunction2Sql(queryString);
    }
}

