/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.adapter;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import setsuna.core.adapter.AbstractDefaultAdapter;
import setsuna.core.adapter.HttpDataInputServlet;
import setsuna.core.adapter.IAdapter;
import setsuna.core.util.SetsunaStaticConfig;

public class DefaultHttpServerAdapter
extends AbstractDefaultAdapter
implements IAdapter {
    static String[] columnList = null;
    static ArrayBlockingQueue nextDataQueue = new ArrayBlockingQueue(1000000);
    private long arrivalTime = 0L;
    static Object nextDataSync = new Object();
    static boolean firstAccess = true;
    private ServletHandler handler = null;
    private Server server = null;
    private InnerHttpServer innerServer = null;
    private boolean stopFlg = false;

    public DefaultHttpServerAdapter(String bindAddress, int bindPort, String[] columnList, long arrivalTime, String context) throws Exception {
        DefaultHttpServerAdapter.columnList = columnList;
        this.arrivalTime = arrivalTime;
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(bindAddress);
        connector.setPort(bindPort);
        this.server.addConnector((Connector)connector);
        ServletHandler handler = new ServletHandler();
        if (context == null) {
            handler.addServletWithMapping(HttpDataInputServlet.class, "/*");
        } else {
            handler.addServletWithMapping(HttpDataInputServlet.class, "/" + context + "/*");
        }
        this.server.setHandler((Handler)handler);
        this.server.start();
        this.innerServer = new InnerHttpServer(this.server);
        this.innerServer.start();
        while (DefaultHttpServerAdapter.columnList == null) {
            Thread.sleep(10L);
        }
    }

    @Override
    public String getName() {
        return SetsunaStaticConfig.DEFAULT_HTTP_SERVER_TABLE_NAME;
    }

    @Override
    public long getArrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public String[] getDataColumnNames() {
        return columnList;
    }

    @Override
    public Map read() throws Exception {
        Map retMap = null;
        try {
            retMap = (Map)nextDataQueue.take();
            super.debug("Server Input=[" + retMap + "]");
            super.outputAdapterData(retMap.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMap;
    }

    @Override
    public boolean stop() {
        this.stopFlg = true;
        try {
            this.innerServer.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    class InnerHttpServer
    extends Thread {
        Server server = null;

        InnerHttpServer(Server server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.join();
            }
            catch (Exception e) {
                try {
                    this.server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

