/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.adapter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.msgpack.rpc.Server;
import org.msgpack.rpc.loop.EventLoop;
import setsuna.core.adapter.AbstractDefaultAdapter;
import setsuna.core.adapter.IAdapter;
import setsuna.core.util.SetsunaStaticConfig;

public class DefaultEasyServerAdapter
extends AbstractDefaultAdapter
implements IAdapter {
    private String[] columnList = null;
    private long arrivalTime = 0L;
    private ArrayBlockingQueue nextDataQueue = null;
    private Object nextDataSync = new Object();
    private boolean firstAccess = true;
    private EventLoop loop = null;
    private Server server = null;
    private InnerServer innerServer = null;
    private boolean stopFlg = false;

    public DefaultEasyServerAdapter(String bindAddress, int bindPort, String[] columnList, long arrivalTime) throws Exception {
        this.columnList = columnList;
        this.nextDataQueue = new ArrayBlockingQueue(1000000);
        this.arrivalTime = arrivalTime;
        this.loop = EventLoop.defaultEventLoop();
        this.server = new Server();
        this.server.serve((Object)this);
        if (bindAddress == null) {
            this.server.listen(bindPort);
        } else {
            this.server.listen(bindAddress, bindPort);
        }
        this.innerServer = new InnerServer(this.server, this.loop);
        this.innerServer.start();
        while (this.columnList == null) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next(String[] data) {
        if (this.firstAccess) {
            Object object = this.nextDataSync;
            synchronized (object) {
                if (this.firstAccess && this.columnList == null) {
                    this.makeColumn(data);
                }
                this.firstAccess = false;
            }
        }
        try {
            if (data.length != this.columnList.length) {
                return -9;
            }
            this.nextDataQueue.put(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private void makeColumn(String[] data) {
        this.columnList = new String[data.length];
        for (int idx = 0; idx < data.length; ++idx) {
            this.columnList[idx] = "COLUMN" + idx;
        }
    }

    @Override
    public String getName() {
        return SetsunaStaticConfig.DEFAULT_EASY_SERVER_TABLE_NAME;
    }

    @Override
    public long getArrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public String[] getDataColumnNames() {
        return this.columnList;
    }

    @Override
    public Map read() throws Exception {
        LinkedHashMap<String, String> retMap = null;
        try {
            retMap = new LinkedHashMap<String, String>();
            String[] data = (String[])this.nextDataQueue.take();
            StringBuilder debugData = new StringBuilder();
            String sep = "";
            for (int idx = 0; idx < this.columnList.length; ++idx) {
                debugData.append(sep);
                debugData.append("[" + idx + "]=\"" + data[idx] + "\"");
                sep = ",";
                retMap.put(this.columnList[idx], data[idx]);
            }
            super.debug("Server Input=[" + debugData + "]");
            super.outputAdapterData(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMap;
    }

    @Override
    public boolean stop() {
        this.stopFlg = true;
        this.innerServer.server.close();
        this.innerServer.loop.shutdown();
        return true;
    }

    class InnerServer
    extends Thread {
        Server server = null;
        EventLoop loop = null;

        InnerServer(Server server, EventLoop loop) {
            this.server = server;
            this.loop = loop;
        }

        @Override
        public void run() {
            try {
                this.loop.join();
            }
            catch (Exception e) {
                try {
                    this.server.close();
                    this.loop.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

