/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Template;
import org.msgpack.rpc.Request;
import org.msgpack.rpc.reflect.Invoker;
import org.msgpack.rpc.reflect.InvokerBuilder;
import org.msgpack.template.TemplateRegistry;

public class ReflectionInvokerBuilder
extends InvokerBuilder {
    private static ReflectionInvokerBuilder instance;

    public static synchronized ReflectionInvokerBuilder getInstance() {
        if (instance == null) {
            instance = new ReflectionInvokerBuilder();
        }
        return instance;
    }

    public Invoker buildInvoker(Method targetMethod, InvokerBuilder.ArgumentEntry[] entries, boolean async) {
        int mod = targetMethod.getModifiers();
        if (!Modifier.isPublic(mod)) {
            targetMethod.setAccessible(true);
        }
        ReflectionArgumentEntry[] res = new ReflectionArgumentEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            InvokerBuilder.ArgumentEntry e = entries[i];
            Class<?> type = e.getType();
            if (!e.isAvailable()) {
                res[i] = new NullArgumentEntry(e);
                continue;
            }
            if (type.equals(Boolean.TYPE)) {
                res[i] = new BooleanArgumentEntry(e);
                continue;
            }
            if (type.equals(Byte.TYPE)) {
                res[i] = new ByteArgumentEntry(e);
                continue;
            }
            if (type.equals(Short.TYPE)) {
                res[i] = new ShortArgumentEntry(e);
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                res[i] = new IntArgumentEntry(e);
                continue;
            }
            if (type.equals(Long.TYPE)) {
                res[i] = new LongArgumentEntry(e);
                continue;
            }
            if (type.equals(Float.TYPE)) {
                res[i] = new FloatArgumentEntry(e);
                continue;
            }
            if (type.equals(Double.TYPE)) {
                res[i] = new DoubleArgumentEntry(e);
                continue;
            }
            Template tmpl = TemplateRegistry.lookup((Type)e.getGenericType(), (boolean)true);
            res[i] = new ObjectArgumentEntry(e, tmpl);
        }
        return new ReflectionInvoker(targetMethod, res, async);
    }

    private static class ReflectionInvoker
    implements Invoker {
        protected Method method;
        protected int parameterLength;
        protected ReflectionArgumentEntry[] entries;
        protected int minimumArrayLength;
        boolean async;

        public ReflectionInvoker(Method method, ReflectionArgumentEntry[] entries, boolean async) {
            this.method = method;
            this.parameterLength = method.getParameterTypes().length;
            this.entries = entries;
            this.async = async;
            this.minimumArrayLength = 0;
            for (int i = 0; i < entries.length; ++i) {
                ReflectionArgumentEntry e = entries[i];
                if (!e.isRequired() && !e.isNullable()) continue;
                this.minimumArrayLength = i + 1;
            }
        }

        public void invoke(Object target, Request request) throws Exception {
            Object[] params = new Object[this.parameterLength];
            if (this.async) {
                params[0] = request;
            }
            try {
                int max;
                int i;
                MessagePackObject args = request.getArguments();
                MessagePackObject[] array = args.asArray();
                int length = array.length;
                if (length < this.minimumArrayLength) {
                    throw new MessageTypeException();
                }
                for (i = 0; i < this.minimumArrayLength; ++i) {
                    ReflectionArgumentEntry e = this.entries[i];
                    if (!e.isAvailable()) continue;
                    MessagePackObject obj = array[i];
                    if (obj.isNil()) {
                        if (e.isRequired()) {
                            throw new MessageTypeException();
                        }
                        if (e.isOptional()) continue;
                        e.setNull(params);
                        continue;
                    }
                    e.convert(params, obj);
                }
                int n = max = length < this.entries.length ? length : this.entries.length;
                while (i < max) {
                    MessagePackObject obj;
                    ReflectionArgumentEntry e = this.entries[i];
                    if (e.isAvailable() && !(obj = array[i]).isNil()) {
                        e.convert(params, obj);
                    }
                    ++i;
                }
            }
            catch (MessageTypeException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            Object result = this.method.invoke(target, params);
            if (!this.async) {
                request.sendResult(result);
            }
        }
    }

    static class ObjectArgumentEntry
    extends ReflectionArgumentEntry {
        private Template template;

        ObjectArgumentEntry(InvokerBuilder.ArgumentEntry e, Template template) {
            super(e);
            this.template = template;
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.convert(this.template);
        }
    }

    static class DoubleArgumentEntry
    extends ReflectionArgumentEntry {
        DoubleArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asDouble();
        }
    }

    static class FloatArgumentEntry
    extends ReflectionArgumentEntry {
        FloatArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = Float.valueOf(obj.asFloat());
        }
    }

    static class LongArgumentEntry
    extends ReflectionArgumentEntry {
        LongArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asLong();
        }
    }

    static class IntArgumentEntry
    extends ReflectionArgumentEntry {
        IntArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asInt();
        }
    }

    static class ShortArgumentEntry
    extends ReflectionArgumentEntry {
        ShortArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asShort();
        }
    }

    static class ByteArgumentEntry
    extends ReflectionArgumentEntry {
        ByteArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asByte();
        }
    }

    static class BooleanArgumentEntry
    extends ReflectionArgumentEntry {
        BooleanArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
            params[this.getIndex()] = obj.asBoolean();
        }
    }

    static class NullArgumentEntry
    extends ReflectionArgumentEntry {
        NullArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public void convert(Object[] params, MessagePackObject obj) throws MessageTypeException {
        }
    }

    static abstract class ReflectionArgumentEntry
    extends InvokerBuilder.ArgumentEntry {
        ReflectionArgumentEntry(InvokerBuilder.ArgumentEntry e) {
            super(e);
        }

        public abstract void convert(Object[] var1, MessagePackObject var2) throws MessageTypeException;

        public void setNull(Object[] params) {
            params[this.getIndex()] = null;
        }
    }
}

