/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.loop.netty;

import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.msgpack.rpc.Server;
import org.msgpack.rpc.address.Address;
import org.msgpack.rpc.config.TcpServerConfig;
import org.msgpack.rpc.loop.netty.NettyEventLoop;
import org.msgpack.rpc.loop.netty.StreamPipelineFactory;
import org.msgpack.rpc.transport.RpcMessageHandler;
import org.msgpack.rpc.transport.ServerTransport;

class NettyTcpServerTransport
implements ServerTransport {
    private Server server;
    private Channel listenChannel;

    NettyTcpServerTransport(TcpServerConfig config, Server server, NettyEventLoop loop) {
        this.server = server;
        Address address = config.getListenAddress();
        RpcMessageHandler handler = new RpcMessageHandler(server);
        handler.useThread(true);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)loop.getServerFactory());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new StreamPipelineFactory(handler));
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("reuseAddress", (Object)true);
        this.listenChannel = bootstrap.bind(address.getSocketAddress());
    }

    public void close() {
        this.listenChannel.close();
    }
}

