/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.loop.netty;

import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.config.TcpClientConfig;
import org.msgpack.rpc.loop.netty.NettyEventLoop;
import org.msgpack.rpc.loop.netty.StreamPipelineFactory;
import org.msgpack.rpc.transport.PooledStreamClientTransport;
import org.msgpack.rpc.transport.RpcMessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NettyTcpClientTransport
extends PooledStreamClientTransport<Channel, ChannelBufferOutputStream> {
    private ClientBootstrap bootstrap;
    private final ChannelFutureListener connectListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                NettyTcpClientTransport.this.onConnectFailed(future.getCause());
                return;
            }
            Channel c = future.getChannel();
            c.getCloseFuture().addListener(NettyTcpClientTransport.this.closeListener);
            NettyTcpClientTransport.this.onConnected(c);
        }
    };
    private final ChannelFutureListener closeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            Channel c = future.getChannel();
            NettyTcpClientTransport.this.onClosed(c);
        }
    };

    NettyTcpClientTransport(TcpClientConfig config, Session session, NettyEventLoop loop) {
        super(config, session);
        RpcMessageHandler handler = new RpcMessageHandler(session);
        this.bootstrap = new ClientBootstrap((ChannelFactory)loop.getClientFactory());
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new StreamPipelineFactory(handler));
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
    }

    @Override
    protected void startConnection() {
        ChannelFuture f = this.bootstrap.connect(this.session.getAddress().getSocketAddress());
        f.addListener(this.connectListener);
    }

    @Override
    protected ChannelBufferOutputStream newPendingBuffer() {
        return new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((ChannelBufferFactory)HeapChannelBufferFactory.getInstance()));
    }

    @Override
    protected void resetPendingBuffer(ChannelBufferOutputStream b) {
        b.buffer().clear();
    }

    @Override
    protected void flushPendingBuffer(ChannelBufferOutputStream b, Channel c) {
        Channels.write((Channel)c, (Object)b.buffer());
    }

    @Override
    protected void closePendingBuffer(ChannelBufferOutputStream b) {
        b.buffer().clear();
    }

    @Override
    protected void sendMessageChannel(Channel c, Object msg) {
        Channels.write((Channel)c, (Object)msg);
    }

    @Override
    protected void closeChannel(Channel c) {
        c.close();
    }
}

