/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.address;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.msgpack.rpc.address.Address;

public class IPAddress
extends Address {
    private byte[] address;
    private int port;

    public IPAddress(String host, int port) throws UnknownHostException {
        this.address = InetAddress.getByName(host).getAddress();
        this.port = port;
    }

    public IPAddress(int port) {
        this.address = new InetSocketAddress(port).getAddress().getAddress();
        this.port = port;
    }

    public IPAddress(InetSocketAddress addr) {
        this.address = addr.getAddress().getAddress();
        this.port = addr.getPort();
    }

    public IPAddress(InetAddress addr, int port) throws UnknownHostException {
        this.address = addr.getAddress();
        this.port = port;
    }

    public InetSocketAddress getInetSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(this.address), this.port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public SocketAddress getSocketAddress() {
        return this.getInetSocketAddress();
    }
}

