/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.msgpack.MessagePackObject;
import org.msgpack.rpc.Request;
import org.msgpack.rpc.SessionPool;
import org.msgpack.rpc.address.IPAddress;
import org.msgpack.rpc.config.ClientConfig;
import org.msgpack.rpc.config.ServerConfig;
import org.msgpack.rpc.config.TcpServerConfig;
import org.msgpack.rpc.dispatcher.Dispatcher;
import org.msgpack.rpc.dispatcher.MethodDispatcher;
import org.msgpack.rpc.error.RPCError;
import org.msgpack.rpc.loop.EventLoop;
import org.msgpack.rpc.transport.MessageSendable;
import org.msgpack.rpc.transport.ServerTransport;

public class Server
extends SessionPool {
    private Dispatcher dp;
    private ServerTransport stran;

    public Server() {
    }

    public Server(ClientConfig config) {
        super(config);
    }

    public Server(EventLoop loop) {
        super(loop);
    }

    public Server(ClientConfig config, EventLoop loop) {
        super(config, loop);
    }

    public void serve(Dispatcher dp) {
        this.dp = dp;
    }

    public void serve(Object handler) {
        this.dp = new MethodDispatcher(handler);
    }

    public void listen(String host, int port) throws UnknownHostException, IOException {
        this.listen(new TcpServerConfig(new IPAddress(host, port)));
    }

    public void listen(InetSocketAddress address) throws IOException {
        this.listen(new TcpServerConfig(new IPAddress(address)));
    }

    public void listen(int port) throws IOException {
        this.listen(new TcpServerConfig(new IPAddress(port)));
    }

    public void listen(ServerConfig config) throws IOException {
        this.stran = this.getEventLoop().listenTransport(config, this);
    }

    public void close() {
        if (this.stran != null) {
            this.stran.close();
        }
        super.close();
    }

    public void onRequest(MessageSendable channel, int msgid, String method, MessagePackObject args) {
        Request request = new Request(channel, msgid, method, args);
        try {
            this.dp.dispatch(request);
        }
        catch (RPCError e) {
            request.sendError(e.getCode(), e);
        }
        catch (Exception e) {
            request.sendError(e.getMessage());
        }
    }

    public void onNotify(String method, MessagePackObject args) {
        Request request = new Request(method, args);
        try {
            this.dp.dispatch(request);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

