/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import setsuna.core.util.SetsunaStaticConfig;
import setsuna.core.util.StreamDatabaseConnectManager;

public class StreamDbUtil {
    public static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    public static final Lock r = rwl.readLock();
    public static final Lock w = rwl.writeLock();
    private static String[] tableCreateTpl = new String[]{"CREATE TABLE ", "%TABLE-NAME%", " (PKEYIDX BIGINT, ", "%COLUMN-DEF%", " )"};
    private static String[] indexCreateTpl = new String[]{"CREATE INDEX INDEX_", "", " ON ", "", "(", "", ")"};
    private static String[] insertSqlTpl = new String[]{"INSERT INTO ", "", " Values(?", "", ",?)"};
    private static String createToNumberAlias = "";
    private static String dropToNumberAlias = "DROP ALIAS TO_NUMBER";
    private static String createToCharAlias = "";
    private static String dropToCharAlias = "DROP ALIAS TO_CHAR";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initUserDBFunction() {
        boolean ret = true;
        Connection conn = null;
        try {
            createToNumberAlias = "CREATE ALIAS TO_NUMBER AS $$ @CODE  double toNumber(String value) {char[] charSep = value.toCharArray();StringBuilder createStr = new StringBuilder();boolean appendFlg = false;for (int i= 0; i < charSep.length; i++) {  if((charSep[i] == '+' && appendFlg == false) || (charSep[i] == '-' && appendFlg == false) || charSep[i] == '0' || charSep[i] == '1'  || charSep[i] == '2'  || charSep[i] == '3'  || charSep[i] == '4'  || charSep[i] == '5'  || charSep[i] == '6'  || charSep[i] == '7'  || charSep[i] == '8'  || charSep[i] == '9'  || charSep[i] == '0'  || charSep[i] == '\uff11'  || charSep[i] == '\uff12' || charSep[i] == '\uff13'   || charSep[i] == '\uff14'  || charSep[i] == '\uff15'  || charSep[i] == '\uff16'  || charSep[i] == '\uff17'  || charSep[i] == '\uff18'  || charSep[i] == '\uff19' || charSep[i] == '0') {   if (charSep[i] == '+') createStr.append(\"+\");if (charSep[i] == '-') createStr.append(\"-\");if(charSep[i] == '1') createStr.append(\"1\");if(charSep[i] == '2') createStr.append(\"2\");if(charSep[i] == '3') createStr.append(\"3\");if(charSep[i] == '4') createStr.append(\"4\");if(charSep[i] == '5') createStr.append(\"5\");if(charSep[i] == '6') createStr.append(\"6\");if(charSep[i] == '7') createStr.append(\"7\");if(charSep[i] == '8') createStr.append(\"8\");if(charSep[i] == '9') createStr.append(\"9\");if(charSep[i] == '0') createStr.append(\"0\");if(charSep[i] == '\uff11') createStr.append(\"1\");if(charSep[i] == '\uff12') createStr.append(\"2\");if(charSep[i] == '\uff13') createStr.append(\"3\");if(charSep[i] == '\uff14') createStr.append(\"4\");if(charSep[i] == '\uff15') createStr.append(\"5\");if(charSep[i] == '\uff16') createStr.append(\"6\");if(charSep[i] == '\uff17') createStr.append(\"7\");if(charSep[i] == '\uff18') createStr.append(\"8\");if(charSep[i] == '\uff19') createStr.append(\"9\");if(charSep[i] == '\uff10') createStr.append(\"0\"); appendFlg = true;  } else if (appendFlg == true) {    break;  }}String tmpCnvCVal = createStr.toString();if (tmpCnvCVal.length() > 0) value = tmpCnvCVal;double valueDouble = Double.parseDouble(value); return valueDouble;}$$;";
            createToCharAlias = "CREATE ALIAS TO_CHAR AS $$ @CODE String toChar(Object obj) { return obj.toString();}$$;";
            PreparedStatement preparedStatement = null;
            int upRet = 0;
            conn = StreamDatabaseConnectManager.getConnection(false);
            try {
                preparedStatement = conn.prepareStatement(dropToNumberAlias);
                upRet = preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (Exception ee1) {
                preparedStatement.close();
                conn.rollback();
                conn.close();
                conn = StreamDatabaseConnectManager.getConnection(false);
            }
            preparedStatement = conn.prepareStatement(createToNumberAlias);
            upRet = preparedStatement.executeUpdate();
            preparedStatement.close();
            try {
                preparedStatement = conn.prepareStatement(dropToCharAlias);
                upRet = preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (Exception ee2) {
                preparedStatement.close();
                conn.rollback();
                conn.close();
                conn = StreamDatabaseConnectManager.getConnection(false);
            }
            preparedStatement = conn.prepareStatement(createToCharAlias);
            upRet = preparedStatement.executeUpdate();
            preparedStatement.close();
            conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    public static boolean createTable(String tableName, String[] columnList) throws Exception {
        block18: {
            Connection conn = null;
            try {
                StringBuilder columnBuf = new StringBuilder(100);
                StringBuilder creataQueryBuf = new StringBuilder(200);
                for (int idx = 0; idx < columnList.length; ++idx) {
                    columnBuf.append(columnList[idx]);
                    columnBuf.append(" VARCHAR(2000), ");
                }
                columnBuf.append("C_TIME TIMESTAMP , PRIMARY KEY(PKEYIDX,C_TIME)");
                creataQueryBuf.append(tableCreateTpl[0]);
                creataQueryBuf.append(tableName);
                creataQueryBuf.append(tableCreateTpl[2]);
                creataQueryBuf.append(columnBuf.toString());
                creataQueryBuf.append(tableCreateTpl[4]);
                conn = StreamDatabaseConnectManager.getConnection(false);
                PreparedStatement preparedStatement = conn.prepareStatement(creataQueryBuf.toString());
                try {
                    StreamDbUtil.dropTable(tableName);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                int ret = preparedStatement.executeUpdate();
                if (ret == 0) {
                    conn.commit();
                    preparedStatement.close();
                    preparedStatement = conn.prepareStatement(indexCreateTpl[0] + tableName + "_C_TIME" + indexCreateTpl[2] + tableName + indexCreateTpl[4] + "C_TIME" + indexCreateTpl[6]);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    for (int idx = 0; idx < columnList.length; ++idx) {
                        preparedStatement = conn.prepareStatement(indexCreateTpl[0] + tableName + "_" + columnList[idx] + indexCreateTpl[2] + tableName + indexCreateTpl[4] + columnList[idx] + indexCreateTpl[6]);
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                    conn.commit();
                    break block18;
                }
                conn.rollback();
                preparedStatement.close();
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                if (conn != null) {
                    conn.rollback();
                }
                throw e;
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ee) {}
            }
        }
        return true;
    }

    public static boolean dropTable(String tableName) throws Exception {
        Connection conn = null;
        try {
            conn = StreamDatabaseConnectManager.getConnection(false);
            PreparedStatement preparedStatement = conn.prepareStatement("DROP TABLE " + tableName);
            int ret = preparedStatement.executeUpdate();
            if (ret != 1) {
                conn.rollback();
                boolean bl = false;
                return bl;
            }
            conn.commit();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ee) {}
        }
        return true;
    }

    public static PreparedStatement createInsertPrepareStatement(Connection conn, String tableName, String[] dataColumnNames) throws Exception {
        int idx;
        PreparedStatement preparedStatement = null;
        StringBuilder insertQueryBuf = new StringBuilder();
        insertQueryBuf.append(insertSqlTpl[0]);
        insertQueryBuf.append(tableName);
        insertQueryBuf.append("(PKEYIDX");
        for (idx = 0; idx < dataColumnNames.length; ++idx) {
            insertQueryBuf.append(",");
            insertQueryBuf.append(dataColumnNames[idx]);
        }
        insertQueryBuf.append(",C_TIME) ");
        insertQueryBuf.append(insertSqlTpl[2]);
        for (idx = 0; idx < dataColumnNames.length; ++idx) {
            insertQueryBuf.append(",");
            insertQueryBuf.append("?");
        }
        insertQueryBuf.append(insertSqlTpl[4]);
        preparedStatement = conn.prepareStatement(insertQueryBuf.toString());
        return preparedStatement;
    }

    public static boolean insertStreamData(PreparedStatement preparedStatement, String[] dataColumnNames, Map readData, long pkeyIdx) throws Exception {
        int ret = 0;
        int mappingParamIdx = 2;
        preparedStatement.setLong(1, pkeyIdx);
        for (int idx = 0; idx < dataColumnNames.length; ++idx) {
            String mappingString = (String)readData.get(dataColumnNames[idx]);
            if (mappingString == null) {
                preparedStatement.setNull(mappingParamIdx, 0);
            } else {
                preparedStatement.setString(mappingParamIdx, mappingString);
            }
            ++mappingParamIdx;
        }
        preparedStatement.setTimestamp(mappingParamIdx, new Timestamp(System.currentTimeMillis()));
        ret = preparedStatement.executeUpdate();
        return ret == 1;
    }

    public static void deleteStreamData(String query, long param) throws Exception {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = StreamDatabaseConnectManager.getConnection(false);
            preparedStatement = conn.prepareStatement(query);
            preparedStatement.setTimestamp(1, new Timestamp(param));
            preparedStatement.executeUpdate();
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            throw e;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static double toNumber(String obj) throws SQLException {
        double ret = 0.0;
        try {
            ret = Double.parseDouble(obj);
        }
        catch (Exception e) {
            throw new SQLException("To number not support type");
        }
        return ret;
    }

    public static String toChar(Object obj) throws SQLException {
        String ret = "";
        try {
            ret = obj.toString();
        }
        catch (Exception e) {
            throw new SQLException("To char not support type");
        }
        return ret;
    }

    static {
        if (SetsunaStaticConfig.SETSUNA_LOCAL_SERVER) {
            StreamDbUtil.initUserDBFunction();
        }
    }
}

