/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.adapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import setsuna.core.AbstractCoreEngine;
import setsuna.core.adapter.IAdapter;
import setsuna.core.util.AdapterJoinQueueMapper;
import setsuna.core.util.SetsunaException;
import setsuna.core.util.SetsunaStaticConfig;
import setsuna.core.util.StreamDatabaseConnectManager;
import setsuna.core.util.StreamDbUtil;

public class SetsunaCoreAdapterEngine
extends AbstractCoreEngine {
    protected IAdapter userAdapter = null;
    protected String[] dataColumnNames = null;
    private DataCleanWorker cleanWorker = null;
    protected boolean stopFlg = false;

    public SetsunaCoreAdapterEngine(IAdapter userAdapter) {
        this.userAdapter = userAdapter;
        AdapterJoinQueueMapper.createMappingInfomation(userAdapter.getName());
    }

    @Override
    public Object preEvent(Object param) throws Exception {
        this.cleanWorker = new DataCleanWorker(this.userAdapter.getName(), this.userAdapter.getArrivalTime(), this);
        this.cleanWorker.start();
        return null;
    }

    @Override
    public Object doEvent(Object preEventResult) throws Exception {
        Map readData;
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        long dataIndex = 0L;
        conn = StreamDatabaseConnectManager.getConnection(true);
        long readCount = 0L;
        boolean skipMode = false;
        if (SetsunaStaticConfig.DATA_INPUT_OFFSET > 0) {
            skipMode = true;
        }
        while ((readData = this.userAdapter.read()) != null) {
            if (skipMode) {
                if (++readCount < (long)SetsunaStaticConfig.DATA_INPUT_OFFSET) continue;
                skipMode = false;
            }
            if (!this.checkDataColumn(readData, this.userAdapter.getDataColumnNames())) {
                if (!SetsunaStaticConfig.ERROR_DATA_SKIP) {
                    throw new SetsunaException("The read data differs from definition information. Adapter name is " + this.userAdapter.getName());
                }
            } else {
                AdapterJoinQueueMapper.mappingAdapterData(this.userAdapter.getName(), readData);
                if (preparedStatement == null) {
                    preparedStatement = StreamDbUtil.createInsertPrepareStatement(conn, this.userAdapter.getName(), this.userAdapter.getDataColumnNames());
                }
                StreamDbUtil.insertStreamData(preparedStatement, this.userAdapter.getDataColumnNames(), readData, dataIndex);
                ++dataIndex;
            }
            if (!this.stopFlg) continue;
            break;
        }
        return null;
    }

    @Override
    public void endEvent(Object doEventResult) throws Exception {
        this.userAdapter = null;
    }

    @Override
    public void stopEvent() {
        this.stopFlg = true;
        this.userAdapter.stop();
    }

    private boolean checkDataColumn(Map readData, String[] defColumnList) {
        for (int idx = 0; idx < defColumnList.length; ++idx) {
            if (readData.containsKey(defColumnList[idx])) continue;
            return false;
        }
        return true;
    }

    class DataCleanWorker
    extends Thread {
        private String tableName = "";
        private SetsunaCoreAdapterEngine parentEngine = null;
        private long arrivalTime = 0L;

        public DataCleanWorker(String tableName, long arrivalTime, SetsunaCoreAdapterEngine parentEngine) {
            this.tableName = tableName;
            this.arrivalTime = arrivalTime;
            this.parentEngine = parentEngine;
        }

        @Override
        public void run() {
            StringBuilder queryBuf = new StringBuilder(100);
            queryBuf.append("DELETE FROM ");
            queryBuf.append(this.tableName);
            queryBuf.append(" WHERE C_TIME < ?");
            String deleteQuery = queryBuf.toString();
            while (!this.parentEngine.stopFlg) {
                try {
                    long deleteTime = System.currentTimeMillis();
                    StreamDbUtil.deleteStreamData(deleteQuery, deleteTime -= this.arrivalTime);
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

