/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import org.msgpack.Template;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateBuildException;
import org.msgpack.template.builder.TemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomTemplateBuilder
implements TemplateBuilder {
    public abstract IFieldEntryReader getFieldEntryReader();

    public abstract Template buildTemplate(Class<?> var1, IFieldEntry[] var2);

    public Template buildTemplate(Class<?> targetClass, FieldOption implicitOption) {
        this.checkValidation(targetClass);
        return this.buildTemplate(targetClass, this.getFieldEntryReader().readFieldEntries(targetClass, implicitOption));
    }

    public Template buildTemplate(Class<?> targetClass, FieldList flist) throws NoSuchFieldException {
        this.checkValidation(targetClass);
        return this.buildTemplate(targetClass, this.getFieldEntryReader().convertFieldEntries(targetClass, flist));
    }

    @Override
    public Template buildTemplate(Type targetType) {
        Class targetClass = (Class)targetType;
        IFieldEntryReader reader = this.getFieldEntryReader();
        FieldOption implicitOption = reader.readImplicitFieldOption(targetClass);
        this.checkValidation(targetClass);
        IFieldEntry[] entries = reader.readFieldEntries(targetClass, implicitOption);
        return this.buildTemplate(targetClass, entries);
    }

    protected void checkValidation(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            throw new TemplateBuildException("Cannot build template of interface");
        }
        if (targetClass.isArray()) {
            throw new TemplateBuildException("Cannot build template of array class");
        }
        if (targetClass.isPrimitive()) {
            throw new TemplateBuildException("Cannot build template of primitive type");
        }
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        throw new UnsupportedOperationException(targetType.toString());
    }

    @Override
    public Template loadTemplate(Type targetType) {
        return null;
    }
}

