/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class LongTemplate
implements Template {
    static final LongTemplate instance = new LongTemplate();

    private LongTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packLong((Long)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackLong();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asLong();
    }

    public static LongTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Long.class, instance);
        TemplateRegistry.register(Long.TYPE, instance);
    }
}

