/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class FloatTemplate
implements Template {
    static final FloatTemplate instance = new FloatTemplate();

    private FloatTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packFloat(((Float)target).floatValue());
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return Float.valueOf(pac.unpackFloat());
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return Float.valueOf(from.asFloat());
    }

    public static FloatTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Float.class, instance);
        TemplateRegistry.register(Float.TYPE, instance);
    }
}

