/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEntry
implements IFieldEntry {
    private Field field;
    private FieldOption option;

    public FieldEntry() {
        this.field = null;
        this.option = FieldOption.IGNORE;
    }

    public FieldEntry(FieldEntry e) {
        this.field = e.field;
        this.option = e.option;
    }

    public FieldEntry(Field field, FieldOption option) {
        this.field = field;
        this.option = option;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public String getJavaTypeName() {
        Class<?> type = this.field.getType();
        if (type.isArray()) {
            return FieldEntry.arrayTypeToString(type);
        }
        return type.getName();
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public FieldOption getOption() {
        return this.option;
    }

    @Override
    public boolean isAvailable() {
        return this.option != FieldOption.IGNORE;
    }

    @Override
    public boolean isRequired() {
        return this.option == FieldOption.REQUIRED;
    }

    @Override
    public boolean isOptional() {
        return this.option == FieldOption.OPTIONAL;
    }

    @Override
    public boolean isNullable() {
        return this.option == FieldOption.NULLABLE;
    }

    static String arrayTypeToString(Class<?> type) {
        int dim = 1;
        Class<?> baseType = type.getComponentType();
        while (baseType.isArray()) {
            baseType = baseType.getComponentType();
            ++dim;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(baseType.getName());
        for (int i = 0; i < dim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

