/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.lang.reflect.Type;
import org.msgpack.MessageConvertable;
import org.msgpack.MessagePackObject;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.MessageUnpackable;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTemplate
implements Template {
    private Class<?> targetClass;
    private Type lookupType;
    private boolean messagePackable;
    private boolean messageUnpackable;
    private boolean messageConvertable;

    public DefaultTemplate(Class<?> targetClass) {
        this(targetClass, targetClass);
    }

    public DefaultTemplate(Class<?> targetClass, Type lookupType) {
        this.targetClass = targetClass;
        this.lookupType = lookupType;
        this.messagePackable = MessagePackable.class.isAssignableFrom(targetClass);
        this.messageUnpackable = MessageUnpackable.class.isAssignableFrom(targetClass);
        this.messageConvertable = MessageConvertable.class.isAssignableFrom(targetClass);
    }

    @Override
    public void pack(Packer pk, Object target) throws IOException {
        if (this.messagePackable) {
            if (target == null) {
                throw new MessageTypeException("target is null.");
            }
            ((MessagePackable)target).messagePack(pk);
            return;
        }
        Template tmpl = TemplateRegistry.tryLookup(this.lookupType);
        if (tmpl == this || tmpl == null) {
            throw new MessageTypeException("Template lookup fail: " + this.lookupType.getClass().getName());
        }
        tmpl.pack(pk, target);
    }

    @Override
    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        if (this.messageUnpackable) {
            if (to == null) {
                try {
                    to = this.targetClass.newInstance();
                }
                catch (Exception e) {
                    throw new MessageTypeException(e);
                }
            }
            ((MessageUnpackable)to).messageUnpack(pac);
            return to;
        }
        Template tmpl = TemplateRegistry.tryLookup(this.lookupType);
        if (tmpl == this || tmpl == null) {
            throw new MessageTypeException("Template lookup fail: " + this.lookupType.getClass().getName());
        }
        return tmpl.unpack(pac, to);
    }

    @Override
    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        if (this.messageConvertable) {
            if (to == null) {
                try {
                    to = this.targetClass.newInstance();
                }
                catch (Exception e) {
                    throw new MessageTypeException(e);
                }
            }
            ((MessageConvertable)to).messageConvert(from);
            return from;
        }
        Template tmpl = TemplateRegistry.tryLookup(this.lookupType);
        if (tmpl == this || tmpl == null) {
            throw new MessageTypeException("Template lookup fail: " + this.lookupType.getClass().getName());
        }
        return tmpl.convert(from, to);
    }
}

