/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.Date;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class DateTemplate
implements Template {
    static final DateTemplate instance = new DateTemplate();

    public void pack(Packer pk, Object target) throws IOException {
        Date temp = (Date)target;
        pk.packLong(temp.getTime());
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        Long temp = pac.unpackLong();
        return new Date(temp);
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        Long temp = from.asLong();
        return new Date(temp);
    }

    public static DateTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Date.class, instance);
    }
}

