/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class BooleanTemplate
implements Template {
    static final BooleanTemplate instance = new BooleanTemplate();

    private BooleanTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packBoolean((Boolean)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackBoolean();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asBoolean();
    }

    public static BooleanTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Boolean.class, instance);
        TemplateRegistry.register(Boolean.TYPE, instance);
    }
}

