/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class BooleanArrayTemplate
implements Template {
    static final BooleanArrayTemplate instance = new BooleanArrayTemplate();

    private BooleanArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof boolean[])) {
            throw new MessageTypeException();
        }
        boolean[] array = (boolean[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (boolean a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        boolean[] array = to != null && to instanceof boolean[] && ((boolean[])to).length == length ? (boolean[])to : new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackBoolean();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        boolean[] array = to != null && to instanceof boolean[] && ((boolean[])to).length == src.length ? (boolean[])to : new boolean[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asBoolean();
        }
        return array;
    }

    public static BooleanArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(boolean[].class, instance);
    }
}

