/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.MessagePackObject;
import org.msgpack.UnpackException;
import org.msgpack.object.ArrayType;
import org.msgpack.object.BooleanType;
import org.msgpack.object.FloatType;
import org.msgpack.object.IntegerType;
import org.msgpack.object.MapType;
import org.msgpack.object.NilType;
import org.msgpack.object.RawType;

public class UnpackerImpl {
    static final int CS_HEADER = 0;
    static final int CS_FLOAT = 10;
    static final int CS_DOUBLE = 11;
    static final int CS_UINT_8 = 12;
    static final int CS_UINT_16 = 13;
    static final int CS_UINT_32 = 14;
    static final int CS_UINT_64 = 15;
    static final int CS_INT_8 = 16;
    static final int CS_INT_16 = 17;
    static final int CS_INT_32 = 18;
    static final int CS_INT_64 = 19;
    static final int CS_RAW_16 = 26;
    static final int CS_RAW_32 = 27;
    static final int CS_ARRAY_16 = 28;
    static final int CS_ARRAY_32 = 29;
    static final int CS_MAP_16 = 30;
    static final int CS_MAP_32 = 31;
    static final int ACS_RAW_VALUE = 32;
    static final int CT_ARRAY_ITEM = 0;
    static final int CT_MAP_KEY = 1;
    static final int CT_MAP_VALUE = 2;
    static final int MAX_STACK_SIZE = 32;
    private int cs;
    private int trail;
    private int top;
    private int[] stack_ct = new int[32];
    private int[] stack_count = new int[32];
    private Object[] stack_obj = new Object[32];
    private int top_ct;
    private int top_count;
    private Object top_obj;
    private ByteBuffer castBuffer = ByteBuffer.allocate(8);
    private boolean finished = false;
    private MessagePackObject data = null;

    public UnpackerImpl() {
        this.reset();
    }

    public final MessagePackObject getData() {
        return this.data;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void resetState() {
        this.cs = 0;
        this.top = -1;
        this.top_ct = 0;
        this.top_count = 0;
        this.top_obj = null;
    }

    public final void reset() {
        this.resetState();
        this.finished = false;
        this.data = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final int execute(byte[] src, int off, int length) throws UnpackException {
        if (off >= length) {
            return off;
        }
        int limit = length;
        int i = off;
        Object var7_6 = null;
        do {
            block51: {
                block54: {
                    int count;
                    block52: {
                        byte b;
                        block60: {
                            MessagePackObject[] messagePackObjectArray;
                            block61: {
                                block58: {
                                    MessagePackObject[] messagePackObjectArray2;
                                    block59: {
                                        block56: {
                                            block57: {
                                                block55: {
                                                    block53: {
                                                        b = src[i];
                                                        if (this.cs != 0) break block52;
                                                        if ((b & 0x80) != 0) break block53;
                                                        IntegerType integerType = IntegerType.create(b);
                                                        break block54;
                                                    }
                                                    if ((b & 0xE0) != 224) break block55;
                                                    IntegerType integerType = IntegerType.create(b);
                                                    break block54;
                                                }
                                                if ((b & 0xE0) != 160) break block56;
                                                this.trail = b & 0x1F;
                                                if (this.trail != 0) break block57;
                                                RawType rawType = RawType.create(new byte[0]);
                                                break block54;
                                            }
                                            this.cs = 32;
                                            break block52;
                                        }
                                        if ((b & 0xF0) != 144) break block58;
                                        if (this.top >= 32) {
                                            throw new UnpackException("parse error");
                                        }
                                        count = b & 0xF;
                                        messagePackObjectArray2 = new MessagePackObject[count];
                                        if (count != 0) break block59;
                                        ArrayType arrayType = ArrayType.create(messagePackObjectArray2);
                                        break block54;
                                    }
                                    ++this.top;
                                    this.stack_obj[this.top] = this.top_obj;
                                    this.stack_ct[this.top] = this.top_ct;
                                    this.stack_count[this.top] = this.top_count;
                                    this.top_obj = messagePackObjectArray2;
                                    this.top_ct = 0;
                                    this.top_count = count;
                                    break block51;
                                }
                                if ((b & 0xF0) != 128) break block60;
                                if (this.top >= 32) {
                                    throw new UnpackException("parse error");
                                }
                                count = b & 0xF;
                                messagePackObjectArray = new MessagePackObject[count * 2];
                                if (count != 0) break block61;
                                MapType mapType = MapType.create(messagePackObjectArray);
                                break block54;
                            }
                            ++this.top;
                            this.stack_obj[this.top] = this.top_obj;
                            this.stack_ct[this.top] = this.top_ct;
                            this.stack_count[this.top] = this.top_count;
                            this.top_obj = messagePackObjectArray;
                            this.top_ct = 1;
                            this.top_count = count;
                            break block51;
                        }
                        switch (b & 0xFF) {
                            case 192: {
                                NilType nilType = NilType.create();
                                break block54;
                            }
                            case 194: {
                                BooleanType booleanType = BooleanType.create(false);
                                break block54;
                            }
                            case 195: {
                                BooleanType booleanType = BooleanType.create(true);
                                break block54;
                            }
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 207: 
                            case 208: 
                            case 209: 
                            case 210: 
                            case 211: {
                                this.trail = 1 << (b & 3);
                                this.cs = b & 0x1F;
                                break;
                            }
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: {
                                this.trail = 2 << (b & 1);
                                this.cs = b & 0x1F;
                                break;
                            }
                            default: {
                                throw new UnpackException("parse error");
                            }
                        }
                    }
                    block32: while (true) {
                        if (limit - i <= this.trail) {
                            return i;
                        }
                        int n = i + 1;
                        i += this.trail;
                        switch (this.cs) {
                            case 10: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                FloatType floatType = FloatType.create(this.castBuffer.getFloat(0));
                                break block32;
                            }
                            case 11: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 8);
                                FloatType floatType = FloatType.create(this.castBuffer.getDouble(0));
                                break block32;
                            }
                            case 12: {
                                IntegerType integerType = IntegerType.create((short)(src[n] & 0xFF));
                                break block32;
                            }
                            case 13: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 2);
                                IntegerType integerType = IntegerType.create(this.castBuffer.getShort(0) & 0xFFFF);
                                break block32;
                            }
                            case 14: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                IntegerType integerType = IntegerType.create((long)this.castBuffer.getInt(0) & 0xFFFFFFFFL);
                                break block32;
                            }
                            case 15: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 8);
                                long o = this.castBuffer.getLong(0);
                                if (o < 0L) {
                                    IntegerType integerType = IntegerType.create(new BigInteger(1, this.castBuffer.array()));
                                    break block32;
                                }
                                IntegerType integerType = IntegerType.create(o);
                                break block32;
                            }
                            case 16: {
                                IntegerType integerType = IntegerType.create(src[n]);
                                break block32;
                            }
                            case 17: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 2);
                                IntegerType integerType = IntegerType.create(this.castBuffer.getShort(0));
                                break block32;
                            }
                            case 18: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                IntegerType integerType = IntegerType.create(this.castBuffer.getInt(0));
                                break block32;
                            }
                            case 19: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 8);
                                IntegerType integerType = IntegerType.create(this.castBuffer.getLong(0));
                                break block32;
                            }
                            case 26: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 2);
                                this.trail = this.castBuffer.getShort(0) & 0xFFFF;
                                if (this.trail == 0) {
                                    RawType rawType = RawType.create(new byte[0]);
                                    break block32;
                                }
                                this.cs = 32;
                                continue block32;
                            }
                            case 27: {
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                this.trail = this.castBuffer.getInt(0) & Integer.MAX_VALUE;
                                if (this.trail == 0) {
                                    RawType rawType = RawType.create(new byte[0]);
                                    break block32;
                                }
                                this.cs = 32;
                                continue block32;
                            }
                            case 32: {
                                byte[] raw = new byte[this.trail];
                                System.arraycopy(src, n, raw, 0, this.trail);
                                RawType rawType = RawType.create(raw);
                                break block32;
                            }
                            case 28: {
                                if (this.top >= 32) {
                                    throw new UnpackException("parse error");
                                }
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 2);
                                count = this.castBuffer.getShort(0) & 0xFFFF;
                                MessagePackObject[] messagePackObjectArray = new MessagePackObject[count];
                                if (count == 0) {
                                    ArrayType arrayType = ArrayType.create(messagePackObjectArray);
                                    break block32;
                                }
                                ++this.top;
                                this.stack_obj[this.top] = this.top_obj;
                                this.stack_ct[this.top] = this.top_ct;
                                this.stack_count[this.top] = this.top_count;
                                this.top_obj = messagePackObjectArray;
                                this.top_ct = 0;
                                this.top_count = count;
                                break block51;
                            }
                            case 29: {
                                if (this.top >= 32) {
                                    throw new UnpackException("parse error");
                                }
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                count = this.castBuffer.getInt(0) & Integer.MAX_VALUE;
                                MessagePackObject[] messagePackObjectArray = new MessagePackObject[count];
                                if (count == 0) {
                                    ArrayType arrayType = ArrayType.create(messagePackObjectArray);
                                    break block32;
                                }
                                ++this.top;
                                this.stack_obj[this.top] = this.top_obj;
                                this.stack_ct[this.top] = this.top_ct;
                                this.stack_count[this.top] = this.top_count;
                                this.top_obj = messagePackObjectArray;
                                this.top_ct = 0;
                                this.top_count = count;
                                break block51;
                            }
                            case 30: {
                                if (this.top >= 32) {
                                    throw new UnpackException("parse error");
                                }
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 2);
                                count = this.castBuffer.getShort(0) & 0xFFFF;
                                MessagePackObject[] messagePackObjectArray = new MessagePackObject[count * 2];
                                if (count == 0) {
                                    MapType mapType = MapType.create(messagePackObjectArray);
                                    break block32;
                                }
                                ++this.top;
                                this.stack_obj[this.top] = this.top_obj;
                                this.stack_ct[this.top] = this.top_ct;
                                this.stack_count[this.top] = this.top_count;
                                this.top_obj = messagePackObjectArray;
                                this.top_ct = 1;
                                this.top_count = count;
                                break block51;
                            }
                            case 31: {
                                if (this.top >= 32) {
                                    throw new UnpackException("parse error");
                                }
                                this.castBuffer.rewind();
                                this.castBuffer.put(src, n, 4);
                                count = this.castBuffer.getInt(0) & Integer.MAX_VALUE;
                                MessagePackObject[] messagePackObjectArray = new MessagePackObject[count * 2];
                                if (count == 0) {
                                    MapType mapType = MapType.create(messagePackObjectArray);
                                    break block32;
                                }
                                ++this.top;
                                this.stack_obj[this.top] = this.top_obj;
                                this.stack_ct[this.top] = this.top_ct;
                                this.stack_count[this.top] = this.top_count;
                                this.top_obj = messagePackObjectArray;
                                this.top_ct = 1;
                                this.top_count = count;
                                break block51;
                            }
                            default: {
                                throw new UnpackException("parse error");
                            }
                        }
                        break;
                    }
                }
                block33: while (true) {
                    void var7_41;
                    if (this.top == -1) {
                        this.data = (MessagePackObject)var7_41;
                        this.finished = true;
                        return ++i;
                    }
                    switch (this.top_ct) {
                        case 0: {
                            Object[] ar = (Object[])this.top_obj;
                            ar[ar.length - this.top_count] = var7_41;
                            if (--this.top_count != 0) break block33;
                            this.top_obj = this.stack_obj[this.top];
                            this.top_ct = this.stack_ct[this.top];
                            this.top_count = this.stack_count[this.top];
                            ArrayType arrayType = ArrayType.create((MessagePackObject[])ar);
                            this.stack_obj[this.top] = null;
                            --this.top;
                            continue block33;
                        }
                        case 1: {
                            Object[] mp = (Object[])this.top_obj;
                            mp[mp.length - this.top_count * 2] = var7_41;
                            this.top_ct = 2;
                            break block33;
                        }
                        case 2: {
                            Object[] mp = (Object[])this.top_obj;
                            mp[mp.length - this.top_count * 2 + 1] = var7_41;
                            if (--this.top_count == 0) {
                                this.top_obj = this.stack_obj[this.top];
                                this.top_ct = this.stack_ct[this.top];
                                this.top_count = this.stack_count[this.top];
                                MapType mapType = MapType.create((MessagePackObject[])mp);
                                this.stack_obj[this.top] = null;
                                --this.top;
                                continue block33;
                            }
                            this.top_ct = 1;
                            break block33;
                        }
                        default: {
                            throw new UnpackException("parse error");
                        }
                    }
                    break;
                }
            }
            this.cs = 0;
        } while (++i < limit);
        return i;
    }
}

