/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import org.msgpack.Template;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.BigDecimalTemplate;
import org.msgpack.template.BigIntegerTemplate;
import org.msgpack.template.BooleanTemplate;
import org.msgpack.template.ByteArrayTemplate;
import org.msgpack.template.ByteBufferTemplate;
import org.msgpack.template.ByteTemplate;
import org.msgpack.template.CollectionTemplate;
import org.msgpack.template.DateTemplate;
import org.msgpack.template.DoubleTemplate;
import org.msgpack.template.FloatTemplate;
import org.msgpack.template.IntegerTemplate;
import org.msgpack.template.ListTemplate;
import org.msgpack.template.LongTemplate;
import org.msgpack.template.MapTemplate;
import org.msgpack.template.NullableTemplate;
import org.msgpack.template.ShortTemplate;
import org.msgpack.template.StringTemplate;
import org.msgpack.template.TemplateRegistry;

public class Templates {
    public static final Template TAny = AnyTemplate.getInstance();
    public static final Template TByte = ByteTemplate.getInstance();
    public static final Template TShort = ShortTemplate.getInstance();
    public static final Template TInteger = IntegerTemplate.getInstance();
    public static final Template TLong = LongTemplate.getInstance();
    public static final Template TBigInteger = BigIntegerTemplate.getInstance();
    public static final Template TBigDecimal = BigDecimalTemplate.getInstance();
    public static final Template TFloat = FloatTemplate.getInstance();
    public static final Template TDouble = DoubleTemplate.getInstance();
    public static final Template TBoolean = BooleanTemplate.getInstance();
    public static final Template TString = StringTemplate.getInstance();
    public static final Template TByteArray = ByteArrayTemplate.getInstance();
    public static final Template TByteBuffer = ByteBufferTemplate.getInstance();
    public static final Template TDate = DateTemplate.getInstance();

    public static Template tNullable(Template elementTemplate) {
        return new NullableTemplate(elementTemplate);
    }

    public static Template tAny() {
        return TAny;
    }

    public static Template tList(Template elementTemplate) {
        return new ListTemplate(elementTemplate);
    }

    public static Template tMap(Template keyTemplate, Template valueTemplate) {
        return new MapTemplate(keyTemplate, valueTemplate);
    }

    public static Template tCollection(Template elementTemplate) {
        return new CollectionTemplate(elementTemplate);
    }

    public static Template tClass(Class target) {
        Template tmpl = TemplateRegistry.lookup(target);
        if (tmpl == null) {
            // empty if block
        }
        return tmpl;
    }

    public static Template tByte() {
        return TByte;
    }

    public static Template tShort() {
        return TShort;
    }

    public static Template tInteger() {
        return TInteger;
    }

    public static Template tLong() {
        return TLong;
    }

    public static Template tBigInteger() {
        return TBigInteger;
    }

    public static Template tBigDecimal() {
        return TBigDecimal;
    }

    public static Template tFloat() {
        return TFloat;
    }

    public static Template tDouble() {
        return TDouble;
    }

    public static Template tBoolean() {
        return TBoolean;
    }

    public static Template tString() {
        return TString;
    }

    public static Template tByteArray() {
        return TByteArray;
    }

    public static Template tByteBuffer() {
        return TByteBuffer;
    }

    public static Template tDate() {
        return TDate;
    }
}

