/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.UnpackException;
import org.msgpack.UnpackResult;
import org.msgpack.UnpackerImpl;

abstract class BufferedUnpackerImpl
extends UnpackerImpl {
    int offset = 0;
    int filled = 0;
    byte[] buffer = null;
    boolean bufferReferenced = false;
    private ByteBuffer castBuffer = ByteBuffer.allocate(8);

    BufferedUnpackerImpl() {
    }

    abstract boolean fill() throws IOException;

    final boolean next(UnpackResult result) throws IOException, UnpackException {
        if (this.filled == 0 && !this.fill()) {
            return false;
        }
        do {
            int noffset;
            if ((noffset = super.execute(this.buffer, this.offset, this.filled)) <= this.offset) {
                if (this.fill()) continue;
                return false;
            }
            this.offset = noffset;
        } while (!super.isFinished());
        MessagePackObject obj = super.getData();
        super.reset();
        result.done(obj);
        return true;
    }

    private final void more(int require) throws IOException, UnpackException {
        while (this.filled - this.offset < require) {
            if (this.fill()) continue;
            throw new UnpackException("insufficient buffer");
        }
    }

    private final boolean tryMore(int require) throws IOException, UnpackException {
        while (this.filled - this.offset < require) {
            if (this.fill()) continue;
            return false;
        }
        return true;
    }

    private final void advance(int length) {
        this.offset += length;
    }

    final byte unpackByte() throws IOException, MessageTypeException {
        int o = this.unpackInt();
        if (127 < o || o < -128) {
            throw new MessageTypeException();
        }
        return (byte)o;
    }

    final short unpackShort() throws IOException, MessageTypeException {
        int o = this.unpackInt();
        if (Short.MAX_VALUE < o || o < Short.MIN_VALUE) {
            throw new MessageTypeException();
        }
        return (short)o;
    }

    final int unpackInt() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0x80) == 0 || (b & 0xE0) == 224) {
            this.advance(1);
            return b;
        }
        switch (b & 0xFF) {
            case 204: {
                this.more(2);
                this.advance(2);
                return (short)this.buffer[this.offset - 1] & 0xFF;
            }
            case 205: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0) & 0xFFFF;
            }
            case 206: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                int o = this.castBuffer.getInt(0);
                if (o < 0) {
                    throw new MessageTypeException();
                }
                this.advance(5);
                return o;
            }
            case 207: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                long o = this.castBuffer.getLong(0);
                if (o < 0L || o > Integer.MAX_VALUE) {
                    throw new MessageTypeException();
                }
                this.advance(9);
                return (int)o;
            }
            case 208: {
                this.more(2);
                this.advance(2);
                return this.buffer[this.offset - 1];
            }
            case 209: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0);
            }
            case 210: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getInt(0);
            }
            case 211: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                long o = this.castBuffer.getLong(0);
                if (Integer.MAX_VALUE < o || o < Integer.MIN_VALUE) {
                    throw new MessageTypeException();
                }
                this.advance(9);
                return (int)o;
            }
        }
        throw new MessageTypeException();
    }

    final long unpackLong() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0x80) == 0 || (b & 0xE0) == 224) {
            this.advance(1);
            return b;
        }
        switch (b & 0xFF) {
            case 204: {
                this.more(2);
                this.advance(2);
                return (short)this.buffer[this.offset - 1] & 0xFF;
            }
            case 205: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0) & 0xFFFF;
            }
            case 206: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return (long)this.castBuffer.getInt(0) & 0xFFFFFFFFL;
            }
            case 207: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                long o = this.castBuffer.getLong(0);
                if (o < 0L) {
                    throw new MessageTypeException();
                }
                this.advance(9);
                return o;
            }
            case 208: {
                this.more(2);
                this.advance(2);
                return this.buffer[this.offset - 1];
            }
            case 209: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0);
            }
            case 210: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getInt(0);
            }
            case 211: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                this.advance(9);
                return this.castBuffer.getLong(0);
            }
        }
        throw new MessageTypeException();
    }

    final BigInteger unpackBigInteger() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0xFF) != 207) {
            return BigInteger.valueOf(this.unpackLong());
        }
        this.more(9);
        this.castBuffer.rewind();
        this.castBuffer.put(this.buffer, this.offset + 1, 8);
        this.advance(9);
        long o = this.castBuffer.getLong(0);
        if (o < 0L) {
            return new BigInteger(1, this.castBuffer.array());
        }
        return BigInteger.valueOf(o);
    }

    final float unpackFloat() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        switch (b & 0xFF) {
            case 202: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getFloat(0);
            }
            case 203: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                this.advance(9);
                return (float)this.castBuffer.getDouble(0);
            }
        }
        throw new MessageTypeException();
    }

    final double unpackDouble() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        switch (b & 0xFF) {
            case 202: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getFloat(0);
            }
            case 203: {
                this.more(9);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 8);
                this.advance(9);
                return this.castBuffer.getDouble(0);
            }
        }
        throw new MessageTypeException();
    }

    final Object unpackNull() throws IOException, MessageTypeException {
        this.more(1);
        int b = this.buffer[this.offset] & 0xFF;
        if (b != 192) {
            throw new MessageTypeException();
        }
        this.advance(1);
        return null;
    }

    final boolean tryUnpackNull() throws IOException {
        if (!this.tryMore(1)) {
            return false;
        }
        int b = this.buffer[this.offset] & 0xFF;
        if (b != 192) {
            return false;
        }
        this.advance(1);
        return true;
    }

    final boolean unpackBoolean() throws IOException, MessageTypeException {
        this.more(1);
        int b = this.buffer[this.offset] & 0xFF;
        if (b == 194) {
            this.advance(1);
            return false;
        }
        if (b == 195) {
            this.advance(1);
            return true;
        }
        throw new MessageTypeException();
    }

    final int unpackArray() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0xF0) == 144) {
            this.advance(1);
            return b & 0xF;
        }
        switch (b & 0xFF) {
            case 220: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0) & 0xFFFF;
            }
            case 221: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getInt(0) & Integer.MAX_VALUE;
            }
        }
        throw new MessageTypeException();
    }

    final int unpackMap() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0xF0) == 128) {
            this.advance(1);
            return b & 0xF;
        }
        switch (b & 0xFF) {
            case 222: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0) & 0xFFFF;
            }
            case 223: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getInt(0) & Integer.MAX_VALUE;
            }
        }
        throw new MessageTypeException();
    }

    final int unpackRaw() throws IOException, MessageTypeException {
        this.more(1);
        byte b = this.buffer[this.offset];
        if ((b & 0xE0) == 160) {
            this.advance(1);
            return b & 0x1F;
        }
        switch (b & 0xFF) {
            case 218: {
                this.more(3);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 2);
                this.advance(3);
                return this.castBuffer.getShort(0) & 0xFFFF;
            }
            case 219: {
                this.more(5);
                this.castBuffer.rewind();
                this.castBuffer.put(this.buffer, this.offset + 1, 4);
                this.advance(5);
                return this.castBuffer.getInt(0) & Integer.MAX_VALUE;
            }
        }
        throw new MessageTypeException();
    }

    final byte[] unpackRawBody(int length) throws IOException {
        this.more(length);
        byte[] bytes = new byte[length];
        System.arraycopy(this.buffer, this.offset, bytes, 0, length);
        this.advance(length);
        return bytes;
    }

    final byte[] unpackByteArray() throws IOException, MessageTypeException {
        int length = this.unpackRaw();
        byte[] body = this.unpackRawBody(length);
        return body;
    }

    final ByteBuffer unpackByteBuffer() throws IOException, MessageTypeException {
        int length = this.unpackRaw();
        this.more(length);
        ByteBuffer buf = ByteBuffer.wrap(this.buffer, this.offset, length);
        this.bufferReferenced = true;
        this.advance(length);
        return buf;
    }

    final String unpackString() throws IOException, MessageTypeException {
        String s;
        int length = this.unpackRaw();
        this.more(length);
        try {
            s = new String(this.buffer, this.offset, length, "UTF-8");
        }
        catch (Exception e) {
            throw new MessageTypeException();
        }
        this.advance(length);
        return s;
    }

    final MessagePackObject unpackObject() throws IOException {
        UnpackResult result = new UnpackResult();
        if (!this.next(result)) {
            super.reset();
            throw new UnpackException("insufficient buffer");
        }
        return result.getData();
    }
}

