/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.MessagePackObject;
import org.msgpack.Template;
import org.msgpack.rpc.Future;
import org.msgpack.rpc.Session;
import org.msgpack.rpc.reflect.InvokerBuilder;
import org.msgpack.rpc.reflect.Proxy;
import org.msgpack.rpc.reflect.ProxyBuilder;
import org.msgpack.template.TemplateRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionProxyBuilder
extends ProxyBuilder {
    private static ReflectionProxyBuilder instance;

    public static synchronized ReflectionProxyBuilder getInstance() {
        if (instance == null) {
            instance = new ReflectionProxyBuilder();
        }
        return instance;
    }

    @Override
    public <T> Proxy<T> buildProxy(Class<T> iface, ProxyBuilder.MethodEntry[] entries) {
        for (ProxyBuilder.MethodEntry e : entries) {
            Method method = e.getMethod();
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod)) continue;
            method.setAccessible(true);
        }
        HashMap<Method, ReflectionMethodEntry> entryMap = new HashMap<Method, ReflectionMethodEntry>();
        for (int i = 0; i < entries.length; ++i) {
            ProxyBuilder.MethodEntry e = entries[i];
            Template tmpl = e.isReturnTypeVoid() ? null : TemplateRegistry.lookup((Type)e.getGenericReturnType(), (boolean)true);
            entryMap.put(e.getMethod(), new ReflectionMethodEntry(e, tmpl));
        }
        return new ReflectionProxy<T>(iface, entryMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReflectionProxy<T>
    implements Proxy<T> {
        private Class<T> iface;
        private Map<Method, ReflectionMethodEntry> entryMap;

        public ReflectionProxy(Class<T> iface, Map<Method, ReflectionMethodEntry> entryMap) {
            this.iface = iface;
            this.entryMap = entryMap;
        }

        @Override
        public T newProxyInstance(Session s) {
            ReflectionHandler handler = new ReflectionHandler(s, this.entryMap);
            return (T)java.lang.reflect.Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)handler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReflectionHandler
    implements InvocationHandler {
        private Session s;
        private Map<Method, ReflectionMethodEntry> entryMap;

        public ReflectionHandler(Session s, Map<Method, ReflectionMethodEntry> entryMap) {
            this.s = s;
            this.entryMap = entryMap;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            ReflectionMethodEntry e = this.entryMap.get(method);
            if (e == null) {
                // empty if block
            }
            Object[] params = e.sort(args);
            if (e.isAsync()) {
                Future<MessagePackObject> f = this.s.callAsyncApply(e.getRpcName(), params);
                return new Future(f, e.getReturnTypeTemplate());
            }
            MessagePackObject obj = this.s.callApply(e.getRpcName(), params);
            Template tmpl = e.getReturnTypeTemplate();
            if (tmpl == null) {
                return null;
            }
            return obj.convert(tmpl);
        }
    }

    private static class ReflectionMethodEntry {
        private String rpcName;
        private Template returnTypeTemplate;
        private boolean async;
        private InvokerBuilder.ArgumentEntry[] argumentEntries;

        public ReflectionMethodEntry(ProxyBuilder.MethodEntry e, Template returnTypeTemplate) {
            this.rpcName = e.getRpcName();
            this.returnTypeTemplate = returnTypeTemplate;
            this.async = e.isAsync();
            this.argumentEntries = e.getArgumentEntries();
        }

        public String getRpcName() {
            return this.rpcName;
        }

        public Template getReturnTypeTemplate() {
            return this.returnTypeTemplate;
        }

        public boolean isAsync() {
            return this.async;
        }

        public Object[] sort(Object[] args) {
            Object[] params = new Object[this.argumentEntries.length];
            for (int i = 0; i < this.argumentEntries.length; ++i) {
                InvokerBuilder.ArgumentEntry e = this.argumentEntries[i];
                if (!e.isAvailable()) continue;
                if (params.length < e.getIndex()) {
                    // empty if block
                }
                if (!e.isRequired() || args[i] == null) {
                    // empty if block
                }
                params[i] = args[e.getIndex()];
            }
            return params;
        }
    }
}

