/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.msgpack.rpc.reflect.InvokerBuilder;
import org.msgpack.rpc.reflect.ProxyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSelector {
    public static Method[] selectRpcServerMethod(Class<?> iface) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : iface.getDeclaredMethods()) {
            if (!MethodSelector.isRpcServerMethod(method)) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public static Method[] selectRpcClientMethod(Class<?> iface) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : iface.getDeclaredMethods()) {
            if (!MethodSelector.isRpcClientMethod(method)) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public static boolean isRpcServerMethod(Method method) {
        return MethodSelector.isRpcMethod(method) && !ProxyBuilder.isAsyncMethod(method);
    }

    public static boolean isRpcClientMethod(Method method) {
        return MethodSelector.isRpcMethod(method) && !InvokerBuilder.isAsyncMethod(method);
    }

    private static boolean isRpcMethod(Method method) {
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        return Modifier.isPublic(mod);
    }
}

