/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.Nullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.Required;
import org.msgpack.rpc.Request;
import org.msgpack.rpc.reflect.Invoker;
import org.msgpack.rpc.reflect.ReflectionInvokerBuilder;
import org.msgpack.template.FieldOption;
import org.msgpack.template.TemplateBuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvokerBuilder {
    private static InvokerBuilder instance;

    public abstract Invoker buildInvoker(Method var1, ArgumentEntry[] var2, boolean var3);

    public Invoker buildInvoker(Method targetMethod, FieldOption implicitOption) {
        InvokerBuilder.checkValidation(targetMethod);
        boolean async = InvokerBuilder.isAsyncMethod(targetMethod);
        return this.buildInvoker(targetMethod, InvokerBuilder.readArgumentEntries(targetMethod, implicitOption, async), async);
    }

    public Invoker buildInvoker(Method targetMethod) {
        InvokerBuilder.checkValidation(targetMethod);
        FieldOption implicitOption = InvokerBuilder.readImplicitFieldOption(targetMethod);
        boolean async = InvokerBuilder.isAsyncMethod(targetMethod);
        return this.buildInvoker(targetMethod, InvokerBuilder.readArgumentEntries(targetMethod, implicitOption, async), async);
    }

    private static synchronized InvokerBuilder getInstance() {
        if (instance == null) {
            instance = InvokerBuilder.selectDefaultInvokerBuilder();
        }
        return instance;
    }

    private static InvokerBuilder selectDefaultInvokerBuilder() {
        return ReflectionInvokerBuilder.getInstance();
    }

    static synchronized void setInstance(InvokerBuilder builder) {
        instance = builder;
    }

    public static Invoker build(Method targetMethod) {
        return InvokerBuilder.getInstance().buildInvoker(targetMethod);
    }

    public static Invoker build(Method targetMethod, FieldOption implicitOption) {
        return InvokerBuilder.getInstance().buildInvoker(targetMethod, implicitOption);
    }

    static boolean isAsyncMethod(Method targetMethod) {
        Class<?>[] types = targetMethod.getParameterTypes();
        return types.length > 0 && types[0].equals(Request.class);
    }

    private static void checkValidation(Method targetMethod) {
    }

    static ArgumentEntry[] readArgumentEntries(Method targetMethod, boolean async) {
        FieldOption implicitOption = InvokerBuilder.readImplicitFieldOption(targetMethod);
        return InvokerBuilder.readArgumentEntries(targetMethod, implicitOption, async);
    }

    static ArgumentEntry[] readArgumentEntries(Method targetMethod, FieldOption implicitOption, boolean async) {
        Type[] types = targetMethod.getGenericParameterTypes();
        Annotation[][] annotations = targetMethod.getParameterAnnotations();
        int paramsOffset = 0;
        if (async) {
            paramsOffset = 1;
        }
        ArrayList<ArgumentEntry> indexed = new ArrayList<ArgumentEntry>();
        int maxIndex = -1;
        for (int i = 0 + paramsOffset; i < types.length; ++i) {
            Type t = types[i];
            Annotation[] as = annotations[i];
            FieldOption opt = InvokerBuilder.readFieldOption(t, as, implicitOption);
            if (opt == FieldOption.IGNORE) continue;
            int index = InvokerBuilder.readFieldIndex(t, as, maxIndex);
            if (indexed.size() > index && indexed.get(index) != null) {
                throw new TemplateBuildException("duplicated index: " + index);
            }
            if (index < 0) {
                throw new TemplateBuildException("invalid index: " + index);
            }
            while (indexed.size() <= index) {
                indexed.add(null);
            }
            indexed.set(index, new ArgumentEntry(i, t, opt));
            if (maxIndex >= index) continue;
            maxIndex = index;
        }
        ArgumentEntry[] result = new ArgumentEntry[maxIndex + 1];
        for (int i = 0; i < indexed.size(); ++i) {
            ArgumentEntry e = (ArgumentEntry)indexed.get(i);
            result[i] = e == null ? new ArgumentEntry() : e;
        }
        return result;
    }

    private static FieldOption readImplicitFieldOption(Method targetMethod) {
        MessagePackMessage a = targetMethod.getAnnotation(MessagePackMessage.class);
        if (a == null) {
            return FieldOption.DEFAULT;
        }
        return a.value();
    }

    private static FieldOption readFieldOption(Type type, Annotation[] as, FieldOption implicitOption) {
        if (InvokerBuilder.isAnnotated(as, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (InvokerBuilder.isAnnotated(as, Required.class)) {
            return FieldOption.REQUIRED;
        }
        if (InvokerBuilder.isAnnotated(as, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (InvokerBuilder.isAnnotated(as, Nullable.class)) {
            if (((Class)type).isPrimitive()) {
                return FieldOption.REQUIRED;
            }
            return FieldOption.NULLABLE;
        }
        if (implicitOption != FieldOption.DEFAULT) {
            return implicitOption;
        }
        return FieldOption.REQUIRED;
    }

    private static int readFieldIndex(Type type, Annotation[] as, int maxIndex) {
        Index a = InvokerBuilder.getAnnotation(as, Index.class);
        if (a == null) {
            return maxIndex + 1;
        }
        return a.value();
    }

    private static boolean isAnnotated(Annotation[] array, Class<? extends Annotation> with) {
        return InvokerBuilder.getAnnotation(array, with) != null;
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] array, Class<T> key) {
        for (Annotation a : array) {
            if (!key.isInstance(a)) continue;
            return (T)a;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArgumentEntry {
        private int index;
        private Type genericType;
        private FieldOption option;

        public ArgumentEntry() {
            this.index = -1;
            this.genericType = null;
            this.option = FieldOption.IGNORE;
        }

        public ArgumentEntry(ArgumentEntry e) {
            this.index = e.index;
            this.genericType = e.genericType;
            this.option = e.option;
        }

        public ArgumentEntry(int index, Type genericType, FieldOption option) {
            this.index = index;
            this.genericType = genericType;
            this.option = option;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?> getType() {
            if (this.genericType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)this.genericType).getRawType();
            }
            return (Class)this.genericType;
        }

        public String getJavaTypeName() {
            Class<?> type = this.getType();
            if (type.isArray()) {
                return ArgumentEntry.arrayTypeToString(type);
            }
            return type.getName();
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public FieldOption getOption() {
            return this.option;
        }

        public boolean isAvailable() {
            return this.option != FieldOption.IGNORE;
        }

        public boolean isRequired() {
            return this.option == FieldOption.REQUIRED;
        }

        public boolean isOptional() {
            return this.option == FieldOption.OPTIONAL;
        }

        public boolean isNullable() {
            return this.option == FieldOption.NULLABLE;
        }

        static String arrayTypeToString(Class<?> type) {
            int dim = 1;
            Class<?> baseType = type.getComponentType();
            while (baseType.isArray()) {
                baseType = baseType.getComponentType();
                ++dim;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(baseType.getName());
            for (int i = 0; i < dim; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
    }
}

