/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.msgpack.MessagePackObject;
import org.msgpack.object.RawType;
import org.msgpack.rpc.Future;
import org.msgpack.rpc.FutureImpl;
import org.msgpack.rpc.address.Address;
import org.msgpack.rpc.config.ClientConfig;
import org.msgpack.rpc.loop.EventLoop;
import org.msgpack.rpc.message.NotifyMessage;
import org.msgpack.rpc.message.RequestMessage;
import org.msgpack.rpc.reflect.Reflect;
import org.msgpack.rpc.transport.ClientTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    protected Address address;
    protected EventLoop loop;
    private ClientTransport transport;
    private int requestTimeout;
    private AtomicInteger seqid = new AtomicInteger(0);
    private Map<Integer, FutureImpl> reqtable = new HashMap<Integer, FutureImpl>();

    Session(Address address, ClientConfig config, EventLoop loop) {
        this.address = address;
        this.loop = loop;
        this.requestTimeout = config.getRequestTimeout();
        this.transport = loop.openTransport(config, this);
    }

    public <T> T proxy(Class<T> iface) {
        return Reflect.reflectProxy(iface).newProxyInstance(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public EventLoop getEventLoop() {
        return this.loop;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public MessagePackObject callApply(String method, Object[] args) {
        Future<MessagePackObject> f = this.sendRequest(method, args);
        while (true) {
            try {
                return f.get();
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public Future<MessagePackObject> callAsyncApply(String method, Object[] args) {
        return this.sendRequest(method, args);
    }

    public void notifyApply(String method, Object[] args) {
        this.sendNotify(method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<MessagePackObject> sendRequest(String method, Object[] args) {
        int msgid = this.seqid.getAndAdd(1);
        RequestMessage msg = new RequestMessage(msgid, method, args);
        FutureImpl f = new FutureImpl(this);
        Map<Integer, FutureImpl> map = this.reqtable;
        synchronized (map) {
            this.reqtable.put(msgid, f);
        }
        this.transport.sendMessage(msg);
        return new Future<MessagePackObject>(f);
    }

    public void sendNotify(String method, Object[] args) {
        NotifyMessage msg = new NotifyMessage(method, args);
        this.transport.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() {
        this.transport.close();
        Map<Integer, FutureImpl> map = this.reqtable;
        synchronized (map) {
            for (Map.Entry<Integer, FutureImpl> pair : this.reqtable.entrySet()) {
                FutureImpl f = pair.getValue();
                f.setResult(null, (MessagePackObject)RawType.create((String)"session closed"));
            }
            this.reqtable.clear();
        }
    }

    public void transportConnectFailed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(int msgid, MessagePackObject result, MessagePackObject error) {
        FutureImpl f;
        Map<Integer, FutureImpl> map = this.reqtable;
        synchronized (map) {
            f = this.reqtable.remove(msgid);
        }
        if (f == null) {
            return;
        }
        f.setResult(result, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepTimeout() {
        ArrayList<FutureImpl> timedout = new ArrayList<FutureImpl>();
        Map<Integer, FutureImpl> map = this.reqtable;
        synchronized (map) {
            Iterator<Map.Entry<Integer, FutureImpl>> it = this.reqtable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, FutureImpl> pair = it.next();
                FutureImpl f = pair.getValue();
                if (!f.stepTimeout()) continue;
                it.remove();
                timedout.add(f);
            }
        }
        for (FutureImpl f : timedout) {
            f.setResult(null, (MessagePackObject)RawType.create((String)"timedout"));
        }
    }
}

