/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.msgpack.MessagePackObject;
import org.msgpack.Template;
import org.msgpack.rpc.FutureImpl;
import org.msgpack.rpc.error.RemoteError;
import org.msgpack.template.TemplateRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Future<V>
implements java.util.concurrent.Future<V> {
    private FutureImpl impl;
    private Template resultTemplate;

    Future(FutureImpl impl) {
        this.impl = impl;
        this.resultTemplate = null;
    }

    Future(FutureImpl impl, Template resultTemplate) {
        this.impl = impl;
        this.resultTemplate = resultTemplate;
    }

    public Future(Future<MessagePackObject> future, Class<V> resultClass) {
        this.impl = future.impl;
        if (resultClass != Void.TYPE) {
            this.resultTemplate = TemplateRegistry.lookup(resultClass);
        }
    }

    public Future(Future<MessagePackObject> future, Template resultTemplate) {
        this.impl = future.impl;
        this.resultTemplate = resultTemplate;
    }

    public void attachCallback(Runnable callback) {
        this.impl.attachCallback(callback);
    }

    @Override
    public V get() throws InterruptedException {
        this.join();
        this.checkThrowError();
        return this.getResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.join(timeout, unit);
        this.checkThrowError();
        return this.getResult();
    }

    public void join() throws InterruptedException {
        this.impl.join();
    }

    public void join(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.impl.join(timeout, unit);
    }

    @Override
    public boolean isDone() {
        return this.impl.isDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public V getResult() {
        MessagePackObject result = this.impl.getResult();
        if (this.resultTemplate == null) {
            return (V)result;
        }
        if (result.isNil()) {
            return null;
        }
        return (V)result.convert(this.resultTemplate);
    }

    public MessagePackObject getError() {
        return this.impl.getError();
    }

    private void checkThrowError() {
        if (!this.getError().isNil()) {
            throw new RemoteError(this.getError());
        }
    }
}

