/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CauseContainer {
    public static Map causeTypeMap = null;
    public static String CAUSE_TYPE_EQUAL = "=";
    public static String CAUSE_TYPE_LIKE = "LIKE";
    public static String CAUSE_TYPE_OVER = ">";
    public static String CAUSE_TYPE_SMALL = "<";
    public static Map numberCnvMap = null;
    protected static Integer colKey = new Integer(1);
    protected static Integer typeKey = new Integer(2);
    protected static Integer causeKey = new Integer(3);
    private List paramList = new ArrayList(10);

    public void add2BuildCause(String buildCauseStr) throws Exception {
        String[] buildList = buildCauseStr.split(" ");
        HashMap<Integer, Object> causeMap = new HashMap<Integer, Object>(3);
        causeMap.put(colKey, buildList[0].toUpperCase());
        causeMap.put(typeKey, (Integer)causeTypeMap.get(buildList[1].toUpperCase()));
        StringBuilder causeValueBuf = new StringBuilder();
        String sep = "";
        for (int idx = 2; idx < buildList.length; ++idx) {
            causeValueBuf.append(sep);
            causeValueBuf.append(buildList[idx]);
            sep = " ";
        }
        causeMap.put(causeKey, causeValueBuf.toString());
        this.paramList.add(causeMap);
    }

    public void addCause(String columnName, String type, String causeValue) {
        HashMap<Integer, Object> causeMap = new HashMap<Integer, Object>(3);
        causeMap.put(colKey, columnName.toUpperCase());
        causeMap.put(typeKey, (Integer)causeTypeMap.get(type.toUpperCase()));
        causeMap.put(causeKey, causeValue);
        this.paramList.add(causeMap);
    }

    public boolean checkAllCauseMatchValue(Map targetValue) {
        boolean ret = true;
        for (int idx = 0; idx < this.paramList.size(); ++idx) {
            Map cause = (Map)this.paramList.get(idx);
            String colName = (String)cause.get(colKey);
            Integer type = (Integer)cause.get(typeKey);
            String causeValue = (String)cause.get(causeKey);
            if (targetValue.containsKey(colName)) {
                String chkValue = (String)targetValue.get(colName);
                if (this.executeCause(chkValue, type, causeValue)) continue;
                ret = false;
                break;
            }
            ret = false;
            break;
        }
        return ret;
    }

    protected boolean executeCause(String value, Integer type, String causeValue) {
        if (value == null || type == null) {
            return false;
        }
        switch (type) {
            case 1: {
                if (!value.equals(causeValue)) break;
                return true;
            }
            case 2: {
                if (value.indexOf(causeValue) == -1) break;
                return true;
            }
            case 3: {
                try {
                    double valueDouble = Double.parseDouble(value);
                    double causeValueDouble = Double.parseDouble(causeValue);
                    if (valueDouble > causeValueDouble) {
                        return true;
                    }
                    break;
                }
                catch (Exception e) {
                    double causeValueDouble;
                    double valueDouble;
                    String tmpCnvCVal;
                    char[] charSep = value.toCharArray();
                    StringBuilder createStr = new StringBuilder();
                    boolean appendFlg = false;
                    for (int i = 0; i < charSep.length; ++i) {
                        if (numberCnvMap.containsKey(Character.valueOf(charSep[i]))) {
                            createStr.append(numberCnvMap.get(Character.valueOf(charSep[i])));
                            appendFlg = true;
                            continue;
                        }
                        if (charSep[i] == '+' && !appendFlg) {
                            createStr.append("+");
                            appendFlg = true;
                            continue;
                        }
                        if (charSep[i] == '-' && !appendFlg) {
                            createStr.append("-");
                            appendFlg = true;
                            continue;
                        }
                        if (appendFlg) break;
                    }
                    if ((tmpCnvCVal = createStr.toString()).length() > 0) {
                        value = tmpCnvCVal;
                    }
                    if (!((valueDouble = Double.parseDouble(value)) > (causeValueDouble = Double.parseDouble(causeValue)))) break;
                    return true;
                }
            }
            case 4: {
                try {
                    double valueDouble = Double.parseDouble(value);
                    double causeValueDouble = Double.parseDouble(causeValue);
                    if (valueDouble > causeValueDouble) {
                        return true;
                    }
                    break;
                }
                catch (Exception e) {
                    double causeValueDouble;
                    double valueDouble;
                    String tmpCnvCVal;
                    char[] charSep = value.toCharArray();
                    StringBuilder createStr = new StringBuilder();
                    boolean appendFlg = false;
                    for (int i = 0; i < charSep.length; ++i) {
                        if (numberCnvMap.containsKey(Character.valueOf(charSep[i]))) {
                            createStr.append(numberCnvMap.get(Character.valueOf(charSep[i])));
                            appendFlg = true;
                            continue;
                        }
                        if (charSep[i] == '+' && !appendFlg) {
                            createStr.append("+");
                            appendFlg = true;
                            continue;
                        }
                        if (charSep[i] == '-' && !appendFlg) {
                            createStr.append("-");
                            appendFlg = true;
                            continue;
                        }
                        if (appendFlg) break;
                    }
                    if ((tmpCnvCVal = createStr.toString()).length() > 0) {
                        value = tmpCnvCVal;
                    }
                    if (!((valueDouble = Double.parseDouble(value)) < (causeValueDouble = Double.parseDouble(causeValue)))) break;
                    return true;
                }
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public void clear() {
        this.paramList = null;
    }

    static {
        causeTypeMap = new ConcurrentHashMap(10, 8.0f, 64);
        causeTypeMap.put(CAUSE_TYPE_EQUAL, 1);
        causeTypeMap.put(CAUSE_TYPE_LIKE, 2);
        causeTypeMap.put(CAUSE_TYPE_OVER, 3);
        causeTypeMap.put(CAUSE_TYPE_SMALL, 4);
        numberCnvMap = new ConcurrentHashMap();
        numberCnvMap.put(Character.valueOf('1'), "1");
        numberCnvMap.put(Character.valueOf('2'), "2");
        numberCnvMap.put(Character.valueOf('3'), "3");
        numberCnvMap.put(Character.valueOf('4'), "4");
        numberCnvMap.put(Character.valueOf('5'), "5");
        numberCnvMap.put(Character.valueOf('6'), "6");
        numberCnvMap.put(Character.valueOf('7'), "7");
        numberCnvMap.put(Character.valueOf('8'), "8");
        numberCnvMap.put(Character.valueOf('9'), "9");
        numberCnvMap.put(Character.valueOf('0'), "0");
        numberCnvMap.put(Character.valueOf('\uff10'), "0");
        numberCnvMap.put(Character.valueOf('\uff19'), "9");
        numberCnvMap.put(Character.valueOf('\uff18'), "8");
        numberCnvMap.put(Character.valueOf('\uff17'), "7");
        numberCnvMap.put(Character.valueOf('\uff16'), "6");
        numberCnvMap.put(Character.valueOf('\uff15'), "5");
        numberCnvMap.put(Character.valueOf('\uff14'), "4");
        numberCnvMap.put(Character.valueOf('\uff13'), "3");
        numberCnvMap.put(Character.valueOf('\uff12'), "2");
        numberCnvMap.put(Character.valueOf('\uff11'), "1");
    }
}

