/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.query;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import setsuna.core.AbstractCoreEngine;
import setsuna.core.util.AdapterJoinQueueMapper;
import setsuna.core.util.CauseContainer;
import setsuna.core.util.ConditionContainer;
import setsuna.core.util.EngineJoinQueueFolder;
import setsuna.core.util.StreamDbUtil;

public class SetsunaCoreQueryEngine
extends AbstractCoreEngine {
    private CauseContainer cause = null;
    private ConditionContainer condition = null;
    private String checkAdapterName = null;
    private boolean stopFlg = false;

    public SetsunaCoreQueryEngine(CauseContainer cause, ConditionContainer condition, String checkAdapterName) {
        this.cause = cause;
        this.condition = condition;
        this.checkAdapterName = checkAdapterName;
    }

    @Override
    public Object preEvent(Object param) throws Exception {
        String myName = super.getEngineName();
        EngineJoinQueueFolder.createaAapterOutputQueue(myName);
        EngineJoinQueueFolder.createaEventInputQueue(myName);
        AdapterJoinQueueMapper.addMappingInfomation(this.checkAdapterName, myName);
        return null;
    }

    @Override
    public Object doEvent(Object preEventResult) throws Exception {
        Map adapterData;
        String myName = super.getEngineName();
        while ((adapterData = (Map)EngineJoinQueueFolder.pollAapterOutputQueue(myName, 50L, TimeUnit.MILLISECONDS)) != null || !this.stopFlg) {
            if (adapterData == null) continue;
            if (this.cause == null && this.condition == null) {
                EngineJoinQueueFolder.putEventInputQueue(myName, adapterData);
                continue;
            }
            if (this.cause == null || this.cause.checkAllCauseMatchValue(adapterData)) {
                StreamDbUtil.r.lock();
                try {
                    if (this.condition == null) {
                        EngineJoinQueueFolder.putEventInputQueue(myName, adapterData);
                    } else if (this.condition.checkConditionMatchRecode()) {
                        EngineJoinQueueFolder.putEventInputQueue(myName, adapterData);
                    }
                }
                catch (Exception ee) {
                    throw ee;
                }
                finally {
                    StreamDbUtil.r.unlock();
                }
            }
            if (!this.stopFlg) continue;
            break;
        }
        return null;
    }

    @Override
    public void endEvent(Object doEventResult) throws Exception {
        if (this.condition != null) {
            this.condition.clear();
        }
        this.cause = null;
        this.condition = null;
    }

    @Override
    public void stopEvent() {
        this.stopFlg = true;
    }
}

