/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.event;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import setsuna.core.event.IScript;
import setsuna.core.util.StreamDatabaseConnectManager;

public class QueryExecuteScript
implements IScript {
    protected String query = null;
    protected Connection conn = null;
    protected PreparedStatement preparedStatement = null;

    public QueryExecuteScript(String query) throws Exception {
        this.query = query;
        this.conn = StreamDatabaseConnectManager.getConnectionReadOnly();
        this.preparedStatement = this.conn.prepareStatement(this.query);
    }

    @Override
    public void execute(Map data) throws Exception {
        Object retList = null;
        String[] columnNameList = null;
        StringBuilder retStrBuf = new StringBuilder();
        ResultSet resultSet = this.executeQuery(new ArrayList());
        ResultSetMetaData metaData = resultSet.getMetaData();
        columnNameList = new String[metaData.getColumnCount()];
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columnNameList[i - 1] = metaData.getColumnName(i);
        }
        String sep = "";
        retStrBuf.append("[");
        while (resultSet.next()) {
            retStrBuf.append(sep);
            retStrBuf.append("{");
            String colSep = "";
            for (int i = 0; i < columnNameList.length; ++i) {
                retStrBuf.append(colSep);
                retStrBuf.append("\"");
                retStrBuf.append(columnNameList[i]);
                retStrBuf.append("\"");
                retStrBuf.append(":");
                retStrBuf.append("\"");
                retStrBuf.append(resultSet.getObject(columnNameList[i]));
                retStrBuf.append("\"");
                colSep = ",";
            }
            retStrBuf.append("}");
            sep = ",";
        }
        retStrBuf.append("]");
        resultSet.close();
        System.out.println(retStrBuf.toString());
    }

    protected ResultSet executeQuery(List parameterList) throws Exception {
        ResultSet resultSet = null;
        for (int idx = 0; idx < parameterList.size(); ++idx) {
            this.preparedStatement.setObject(idx + 1, parameterList.get(idx));
        }
        resultSet = this.preparedStatement.executeQuery();
        return resultSet;
    }
}

