/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import setsuna.core.AbstractCoreEngine;
import setsuna.core.adapter.IAdapter;
import setsuna.core.adapter.SetsunaCoreAdapterEngine;
import setsuna.core.event.SetsunaCoreEventEngine;
import setsuna.core.query.SetsunaCoreQueryEngine;
import setsuna.core.util.CauseContainer;
import setsuna.core.util.ConditionContainer;
import setsuna.core.util.EventContainer;
import setsuna.core.util.SetsunaException;
import setsuna.core.util.StreamDatabaseConnectManager;
import setsuna.core.util.StreamDbUtil;

public class SetsunaCore {
    private Map executeAdapterEngineMap = new ConcurrentHashMap(100, 80.0f, 64);
    private Map executeQueryEngineMap = new ConcurrentHashMap(100, 80.0f, 64);
    private Map executeEventEngineMap = new ConcurrentHashMap(100, 80.0f, 64);
    private String setsunaServerInfomation = null;

    public AbstractCoreEngine executeAdapterEngine(String adapterClassPath) throws Exception {
        try {
            IAdapter adapter = (IAdapter)Class.forName(adapterClassPath).newInstance();
            return this.executeAdapterEngine(adapter);
        }
        catch (ClassNotFoundException ce) {
            throw new SetsunaException(adapterClassPath + ":Class not found", ce);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public AbstractCoreEngine executeAdapterEngine(IAdapter adapter) throws Exception {
        AbstractCoreEngine setsunaCoreAdapterEngine;
        block11: {
            setsunaCoreAdapterEngine = null;
            String engineName = adapter.getName() + "_Engine";
            if (this.executeAdapterEngineMap.containsKey(engineName)) {
                setsunaCoreAdapterEngine = (AbstractCoreEngine)this.executeAdapterEngineMap.get(engineName);
                setsunaCoreAdapterEngine.stopEvent();
                setsunaCoreAdapterEngine.join();
                setsunaCoreAdapterEngine = null;
                StreamDbUtil.w.lock();
                try {
                    if (!StreamDbUtil.dropTable(adapter.getName())) {
                        throw new SetsunaException("Failed in a change of Adapter 1.");
                    }
                    if (!StreamDbUtil.createTable(adapter.getName(), adapter.getDataColumnNames())) {
                        throw new SetsunaException("Failed in a change of Adapter 2.");
                    }
                    setsunaCoreAdapterEngine = new SetsunaCoreAdapterEngine(adapter);
                    setsunaCoreAdapterEngine.setEngineName(engineName);
                    setsunaCoreAdapterEngine.start();
                    this.executeAdapterEngineMap.put(engineName, setsunaCoreAdapterEngine);
                    break block11;
                }
                catch (Exception ee) {
                    throw ee;
                }
                finally {
                    StreamDbUtil.w.unlock();
                }
            }
            if (!StreamDbUtil.createTable(adapter.getName(), adapter.getDataColumnNames())) {
                throw new SetsunaException("Failed in a change of Adapter 3.");
            }
            setsunaCoreAdapterEngine = new SetsunaCoreAdapterEngine(adapter);
            setsunaCoreAdapterEngine.setEngineName(engineName);
            setsunaCoreAdapterEngine.start();
            this.executeAdapterEngineMap.put(engineName, setsunaCoreAdapterEngine);
        }
        return setsunaCoreAdapterEngine;
    }

    public AbstractCoreEngine executeQueryEngine(String queryName, String checkAdapterName, CauseContainer causeContainer, ConditionContainer conditionContainer) throws Exception {
        AbstractCoreEngine setsunaCoreQueryEngine = null;
        String engineName = queryName + "_Engine";
        if (this.executeQueryEngineMap.containsKey(engineName)) {
            setsunaCoreQueryEngine = (AbstractCoreEngine)this.executeQueryEngineMap.get(engineName);
            setsunaCoreQueryEngine.stopEvent();
            setsunaCoreQueryEngine.join(60000L);
            setsunaCoreQueryEngine = null;
            conditionContainer.buildStreamDatabaseStatement(StreamDatabaseConnectManager.getConnection(false));
            setsunaCoreQueryEngine = new SetsunaCoreQueryEngine(causeContainer, conditionContainer, checkAdapterName);
            setsunaCoreQueryEngine.setEngineName(queryName);
            setsunaCoreQueryEngine.start();
            this.executeQueryEngineMap.put(engineName, setsunaCoreQueryEngine);
        } else {
            if (conditionContainer != null) {
                conditionContainer.buildStreamDatabaseStatement(StreamDatabaseConnectManager.getConnection(false));
            }
            setsunaCoreQueryEngine = new SetsunaCoreQueryEngine(causeContainer, conditionContainer, checkAdapterName);
            setsunaCoreQueryEngine.setEngineName(queryName);
            setsunaCoreQueryEngine.start();
            this.executeQueryEngineMap.put(engineName, setsunaCoreQueryEngine);
        }
        return setsunaCoreQueryEngine;
    }

    public AbstractCoreEngine executeEventEngine(EventContainer eventContainer, String queryName) throws Exception {
        AbstractCoreEngine setsunaCoreEventEngine = null;
        String engineName = eventContainer.getEventName() + "_Engine";
        if (this.executeEventEngineMap.containsKey(engineName)) {
            setsunaCoreEventEngine = (AbstractCoreEngine)this.executeEventEngineMap.get(engineName);
            setsunaCoreEventEngine.stopEvent();
            setsunaCoreEventEngine.join(60000L);
            setsunaCoreEventEngine = null;
            setsunaCoreEventEngine = new SetsunaCoreEventEngine(eventContainer, queryName);
            setsunaCoreEventEngine.setEngineName(engineName);
            setsunaCoreEventEngine.start();
            this.executeEventEngineMap.put(engineName, setsunaCoreEventEngine);
        } else {
            setsunaCoreEventEngine = new SetsunaCoreEventEngine(eventContainer, queryName);
            setsunaCoreEventEngine.setEngineName(engineName);
            setsunaCoreEventEngine.start();
            this.executeEventEngineMap.put(engineName, setsunaCoreEventEngine);
        }
        return setsunaCoreEventEngine;
    }
}

