/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Embedded;
import org.apache.log4j.Logger;
import org.red5.server.LoaderBase;
import org.red5.server.LoaderMBean;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.tomcat.TomcatApplicationContext;
import org.red5.server.tomcat.TomcatApplicationLoader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatLoader
extends LoaderBase
implements ApplicationContextAware,
LoaderMBean {
    protected static ThreadLocal<ApplicationContext> applicationContext = new ThreadLocal();
    protected static Logger log = Logger.getLogger((String)TomcatLoader.class.getName());
    private Host baseHost;
    protected Connector connector;
    protected Embedded embedded;
    protected Engine engine;
    protected Realm realm;

    public TomcatLoader() {
        JMXAgent.registerMBean(this, this.getClass().getName(), LoaderMBean.class);
    }

    public Context addContext(String path, String docBase) {
        Context c = this.embedded.createContext(path, docBase);
        this.baseHost.addChild((Container)c);
        LoaderBase.setRed5ApplicationContext(path, new TomcatApplicationContext(c));
        return c;
    }

    public Host getBaseHost() {
        return this.baseHost;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Embedded getEmbedded() {
        return this.embedded;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public void init() {
        File[] dirs;
        log.info((Object)"Loading tomcat context");
        try {
            TomcatLoader.getApplicationContext();
        }
        catch (Exception e) {
            log.error((Object)"Error loading tomcat configuration", (Throwable)e);
        }
        if (this.webappFolder == null) {
            this.webappFolder = System.getProperty("red5.root") + "/webapps";
        }
        System.setProperty("red5.webapp.root", this.webappFolder);
        log.info((Object)("Application root: " + this.webappFolder));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Approot: " + this.webappFolder));
        }
        File appDirBase = new File(this.webappFolder);
        for (File file : dirs = appDirBase.listFiles(new DirectoryFilter())) {
            String dirName = '/' + file.getName();
            if (null != this.baseHost.findChild(dirName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding context from directory scan: " + dirName));
            }
            this.addContext(dirName, this.webappFolder + '/' + dirName);
        }
        if (log.isDebugEnabled()) {
            for (File file : this.baseHost.findChildren()) {
                log.debug((Object)("Context child name: " + file.getName()));
            }
        }
        this.embedded.setRealm(this.realm);
        this.embedded.setUseNaming(false);
        this.engine.addChild((Container)this.baseHost);
        this.embedded.addEngine(this.engine);
        this.embedded.addConnector(this.connector);
        TomcatLoader.setApplicationLoader(new TomcatApplicationLoader(this.embedded, this.baseHost));
        try {
            log.info((Object)"Starting tomcat servlet engine");
            this.embedded.start();
        }
        catch (LifecycleException e) {
            log.error((Object)"Error loading tomcat", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext.set(context);
    }

    public void setBaseHost(Host baseHost) {
        log.debug((Object)"setBaseHost");
        this.baseHost = baseHost;
    }

    public void setConnector(Connector connector) {
        log.info((Object)("Setting connector: " + connector.getClass().getName()));
        this.connector = connector;
    }

    public void setConnectors(List<Connector> connectors) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setConnectors: " + connectors.size()));
        }
        for (Connector ctr : connectors) {
            this.embedded.addConnector(ctr);
        }
    }

    public void setContexts(Map<String, String> contexts) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setContexts: " + contexts.size()));
        }
        for (String key : contexts.keySet()) {
            this.baseHost.addChild((Container)this.embedded.createContext(key, this.webappFolder + contexts.get(key)));
        }
    }

    public void setEmbedded(Embedded embedded) {
        log.info((Object)("Setting embedded: " + embedded.getClass().getName()));
        this.embedded = embedded;
    }

    public void setEngine(Engine engine) {
        log.info((Object)("Setting engine: " + engine.getClass().getName()));
        this.engine = engine;
    }

    public void setHosts(List<Host> hosts) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setHosts: " + hosts.size()));
        }
        for (Host host : hosts) {
            this.engine.addChild((Container)host);
        }
    }

    public void setRealm(Realm realm) {
        log.info((Object)("Setting realm: " + realm.getClass().getName()));
        this.realm = realm;
    }

    public void setValves(List<Valve> valves) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValves: " + valves.size()));
        }
        for (Valve valve : valves) {
            ((StandardHost)this.baseHost).addValve(valve);
        }
    }

    @Override
    public void shutdown() {
        log.info((Object)"Shutting down tomcat context");
        JMXAgent.shutdown();
        try {
            this.embedded.stop();
            System.exit(0);
        }
        catch (Exception e) {
            log.warn((Object)"Tomcat could not be stopped", (Throwable)e);
            System.exit(1);
        }
    }

    static {
        log.info((Object)"Init tomcat");
        String serverRoot = System.getProperty("red5.root");
        log.info((Object)("Server root: " + serverRoot));
        String confRoot = System.getProperty("red5.config_root");
        log.info((Object)("Config root: " + confRoot));
        System.setProperty("tomcat.home", serverRoot);
        System.setProperty("catalina.home", serverRoot);
        System.setProperty("catalina.base", serverRoot);
    }

    class DirectoryFilter
    implements FilenameFilter {
        DirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filtering: " + dir.getName() + " name: " + name));
                log.debug((Object)("Constructed dir: " + f.getAbsolutePath()));
            }
            return f.isDirectory() && f.canRead() && !f.isHidden();
        }
    }
}

